package com.bokesoft.yigoee.tech.bootsupport.web.enhancements.resver.intf;

import java.util.List;

/**
 * 静态资源版本处理上下文
 */
public interface IStaticResourceVersionContext {
    /**
     * 获取指定名称的资源内容
     * @param fileName
     * @return 一个文件名可能返回多个文件
     */
    List<String> getContents(String fileName);

    /**
     * 在一个处理上下文中, 获取缓存的文件版本摘要信息
     * @param fileName
     * @return
     */
    String getCachedVersion(String fileName);

    /**
     * 在一个处理上下文中, 缓存文件的版本摘要信息
     * @param fileName
     * @param version
     */    
    void cacheVersion(String fileName, String version);

    /**
     * 标明处理上下文包含跟踪信息
     */
    public static interface Traceable {
        void nodeCreated(int traceId, String nodeName);
        void versionCreated(int traceId, String version);
        void updateInstanceCount(int traceId, int count);
        void appendChild(int parentTraceId, int traceId);
    }
}
