package com.bokesoft.yigoee.tech.bootsupport.web.enhancements.resver.config;

import java.util.ArrayList;
import java.util.List;

/**
 * 静态资源处理配置
 */
public class StaticUrlVersionSetting {
    /**
     * 默认情况下需要处理的 URL Patterns: "*.js", "*.css", "*.less"
     */
    public static final String[] DEFAULT_STATIC_URL_PATTERNS = new String[] {
        "*.js", "*.css", "*.less"
    };

    /**
     * 需要进行静态资源版本处理的请求路径清单, 支持 Path 通配符.
     * 例如 /yesui/ux/** .
     */
    private List<String> requestPathPatterns = new ArrayList<>();
    /**
     * 资源文件搜索路径清单, 支持 Path 通配符; 注意: 路径仅到目录, 结尾不应该包含 "/", 不需要具体在文件名.
     * 例如 classpath*:/webapps/yigo/yesui/ux/** .
     */    
    private List<String> resourceSearchPathPatterns = new ArrayList<>();
    /**
     * 排除路径资源清单, 支持 Path 通配符.
     */
    private List<String> excludeResourcePatterns = new ArrayList<>();

    public List<String> getRequestPathPatterns() {
        return requestPathPatterns;
    }
    public void setRequestPathPatterns(List<String> requestPathPatterns) {
        this.requestPathPatterns = requestPathPatterns;
    }

    public List<String> getResourceSearchPathPatterns() {
        return resourceSearchPathPatterns;
    }
    public void setResourceSearchPathPatterns(List<String> resourceSearchPathPatterns) {
        this.resourceSearchPathPatterns = resourceSearchPathPatterns;
    }

    public List<String> getExcludeResourcePatterns() {
        return excludeResourcePatterns;
    }
    public void setExcludeResourcePatterns(List<String> excludeResourcePatterns) {
        this.excludeResourcePatterns = excludeResourcePatterns;
    }
}
