package com.bokesoft.yigo.commons.slnbase.service.right.quarz;

import com.bokesoft.yigo.commons.slnbase.service.right.util.RightCacheUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.schedule.DefaultScheduleJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Map;

/**
 * 清除离线用户cache
 * quartz_jobs.xml配置参考如下:
 *   <p><schedule>
 *    		 <job>
 *            <name>RIGHT_CACHE_CLEAR</name>
 *            <group>RIGHT_CACHE_CLEAR</group>
 *            <description>定时任务清除YIGO权限缓存</description>
 *            <job-class>com.bokesoft.yigo.commons.slnbase.service.right.quarz.ClearRightCacheJob</job-class>
 *        </job>
 *        <trigger>
 * 	      	<simple>
 *                 <name>RIGHT_CACHE_CLEAR</name>
 *                 <group>RIGHT_CACHE_CLEAR</group>
 *                 <job-name>RIGHT_CACHE_CLEAR</job-name>
 *                 <job-group>RIGHT_CACHE_CLEAR</job-group>
 *                 <start-time>2015-12-08T16:27:00</start-time>
 *                 <repeat-count>-1</repeat-count>
 *                 <repeat-interval>900000</repeat-interval>
 *             </simple>
 *        </trigger>
 *     </schedule>
 *    </p>
*/
public class ClearRightCacheJob extends DefaultScheduleJob {
    @Override
    public void doJob(DefaultContext defaultContext, Map<String, Object> map) {
        RightCacheUtil.clearCacheOffline();
    }
}
