package com.bokesoft.yigo.commons.slnbase.service.login;

import java.util.Date;

import com.bokesoft.distro.tech.yigosupport.extension.base.IStaticMethodByNameExtServiceWrapper;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.common.def.LoginMode;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.session.ISessionInfo;
import com.bokesoft.yigo.mid.session.ISessionInfoMap;
import com.bokesoft.yigo.mid.session.SessionInfoProviderHolder;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;

/**
 * 在线用户登录数据相关公式
 */
public class LoginInfoService implements IStaticMethodByNameExtServiceWrapper {
    /**
     * 载入在线用户登录数据
     * 
     * @param context 上下文对象
     * @param mode 登录模式, 参考 {@link LoginMode}
     * @param operatorId 操作员 ID
     * @param clientId 用户会话的 client ID
     * @param loginBegin 登录时间范围 / 开始
     * @param loginEnd 登录时间范围 / 结束
     * @return 在线用户登录数据
     */
    public static DataTable loadLoginData(DefaultContext context, Number mode, Long operatorId, String clientId,
            Date loginBegin, Date loginEnd) throws Throwable {
        ISessionInfoMap sessionInfoMap = SessionInfoProviderHolder.getProvider(mode.intValue()).getSessionInfoMap();
        Document doc = context.getDocument();
        DataTable dt = doc.get("YIGO_COMMONS_SessionMgr");
        dt.clear();
        for (String key : sessionInfoMap.getKeys()) {
            ISessionInfo sessionInfo = sessionInfoMap.get(key);
            long sessionOperatorId = sessionInfo.getOperatorID();
            if (operatorId != null && operatorId > 0) {
                if (sessionOperatorId != operatorId) {
                    continue;
                }
            }
            String sessionClientId = sessionInfo.getClientID();
            if (!StringUtil.isBlankOrNull(clientId)) {
                if (!sessionClientId.equals(clientId)) {
                    continue;
                }
            }

            Date sessionLoginTime = sessionInfo.getLoginTime();
            if (loginBegin != null) {
                if (loginBegin.compareTo(sessionLoginTime) < 0) {
                    continue;
                }
            }
            if (loginEnd != null) {
                if (loginBegin.compareTo(loginEnd) > 0) {
                    continue;
                }
            }
            dt.append();
            dt.setInt("Mode", sessionInfo.getMode());
            dt.setLong("OperatorID", sessionOperatorId);
            dt.setString("ClientID", sessionClientId);
            dt.setString("AppID", sessionInfo.getAppID());
            dt.setString("IP", sessionInfo.getIP());
            dt.setDateTime("CreateTime", sessionInfo.getCreateTime());
            dt.setDateTime("LoginTime", sessionInfo.getLoginTime());
            dt.setDateTime("LastActiveTime", sessionInfo.getLastActiveTime());
            dt.setInt("LoginFailedCount", sessionInfo.getLoginFailedCount());
        }
        dt.batchUpdate();
        return dt;
    }

}
