package com.bokesoft.yigo.commons.slnbase.service.config;

import java.util.List;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import com.bokesoft.yigo.commons.slnbase.service.SlnBaseConfiguration;

@Configuration
@ConfigurationProperties(prefix=SlnBaseConfiguration.ROOT_CONFIG_PREFIX)
public class SlnBaseConfig {
    /*
     * 是否忽略内置的 "boot" Solution(yigo-base-solution-solutions/solutions/sln-yigo-commons-sln-boot),
     * 默认会作为 primary solution 加入系统.
     */
    private boolean ignoreBuildinBootSolution = false;
    /**
     * 是否忽略内置的 "base" Solution(yigo-base-solution-solutions/solutions/sln-yigo-commons-sln-base),
     * 默认会作为 solution 加入系统.
     */
    private boolean ignoreBuildinBaseSolution = false;

    /** 集成 Yigo Solution 时, 可以额外忽略的 "base" Solution 的资源路径 */
    private List<String> ignoreBaseResources;

    /**
     * 定义内置的 "boot" Solution(yigo-base-solution-solutions/solutions/sln-yigo-commons-sln-boot) 的资源路径,
     * 在设计器中设计时, 需要修改默认值, 改为 file:// 路径
     */
    private String bootSolutionLocation = "classpath:/sln-yigo-commons-sln-boot";
    /**
     * 定义内置的 "base" Solution(yigo-base-solution-solutions/solutions/sln-yigo-commons-sln-base) 的资源路径,
     * 在设计器中设计时, 需要修改默认值, 改为 file:// 路径
     */
    private String baseSolutionLocation = "classpath:/sln-yigo-commons-sln-base";

    public boolean isIgnoreBuildinBootSolution() {
        return ignoreBuildinBootSolution;
    }
    public void setIgnoreBuildinBootSolution(boolean ignoreBuildinRootSolution) {
        this.ignoreBuildinBootSolution = ignoreBuildinRootSolution;
    }
    public boolean isIgnoreBuildinBaseSolution() {
        return ignoreBuildinBaseSolution;
    }
    public void setIgnoreBuildinBaseSolution(boolean ignoreBuildinBaseSolution) {
        this.ignoreBuildinBaseSolution = ignoreBuildinBaseSolution;
    }

    public List<String> getIgnoreBaseResources() {
        return ignoreBaseResources;
    }
    public void setIgnoreBaseResources(List<String> ignoreResources) {
        this.ignoreBaseResources = ignoreResources;
    }

    public String getBootSolutionLocation() {
        return bootSolutionLocation;
    }
    public void setBootSolutionLocation(String bootSolutionLocation) {
        this.bootSolutionLocation = bootSolutionLocation;
    }
    public String getBaseSolutionLocation() {
        return baseSolutionLocation;
    }
    public void setBaseSolutionLocation(String baseSolutionLocation) {
        this.baseSolutionLocation = baseSolutionLocation;
    }
}
