package com.bokesoft.yigo.commons.slnbase.service.right.util;


import com.bokesoft.yes.mid.server.ServiceRequest;
import com.bokesoft.yes.mid.server.ServiceResponse;
import com.bokesoft.yigo.commons.slnbase.service.right.struct.DictRight;
import com.bokesoft.yigo.commons.slnbase.service.right.struct.FormRight;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.server.IServiceRequest;
import com.bokesoft.yigo.mid.server.dispatcher.util.ServiceUtil;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.env.Env;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import java.util.*;

public class RightUtil {
    /**超级管理员用户id*/
    private static final Long ADMIN_USER_ID = 21l;
    /**超级管理员角色id*/
    private static final Long ADMIN_ROLE_ID = 11l;

    /**
     * 加载菜单权限(调用现有yigo内部服务,避免自己二次封装)
     * @param context
     * @param roleID
     * @param operatorID
     * @return
     * @throws Throwable
     */
    public static EntryRightData loadEntryRights(DefaultContext context, long roleID, long operatorID) throws Throwable {
        IServiceRequest req = new ServiceRequest(context.getEnv());
        req.getParameterMap().put("service", "SetRightsService");
        req.getParameterMap().put("cmd", "LoadEntryRightsData");
        req.getParameterMap().put("operatorID", operatorID);
        req.getParameterMap().put("roleID", roleID);
        ServiceResponse resp = new ServiceResponse();
        ServiceUtil.createLocalDispatcher(req).processService(req, resp);
        JSONObject obj = (JSONObject) resp.getResult();
        JSONObject data = (JSONObject) obj.get("data");
        ObjectMapper m = new ObjectMapper();
        EntryRightData rightsData = m.readValue(data.toString(), EntryRightData.class);
        return rightsData;
    }

    /**
     * 加载表单(操作/字段)权限(调用现有yigo内部服务,避免自己二次封装)
     * @param context
     * @param formKey
     * @param roleID
     * @param operatorID
     * @return
     */
    public static FormRightsData loadFormRights(DefaultContext context, String formKey, long roleID, long operatorID) throws Throwable {
        IServiceRequest req = new ServiceRequest(context.getEnv());
        req.getParameterMap().put("service", "SetRightsService");
        req.getParameterMap().put("cmd", "LoadFormRightsData");
        req.getParameterMap().put("formKey", formKey);
        req.getParameterMap().put("operatorID", operatorID);
        req.getParameterMap().put("roleID", roleID);
        ServiceResponse resp = new ServiceResponse();
        ServiceUtil.createLocalDispatcher(req).processService(req, resp);
        JSONObject obj = (JSONObject) resp.getResult();
        JSONObject data = (JSONObject) obj.get("data");
        ObjectMapper m = new ObjectMapper();
        FormRightsData formRightsData = m.readValue(data.toString(), FormRightsData.class);
        return formRightsData;
    }

    /**
     * 判断当前是否是超级管理员或者拥有超级管理员角色
     * @param ctx
     * @return
     */
    public static boolean isAdmin(DefaultContext ctx) {
        Env env = ctx.getVE().getEnv();
        List<Long> roleIDList = env.getRoleIDList();
        Long userId = env.getUserID();
        return ADMIN_USER_ID.equals(userId) || roleIDList.contains(ADMIN_ROLE_ID);
    }

    /**
     * 加载字典数据权限
     * @param ctx
     * @param itemKey
     * @param roleID
     * @param operatorID
     * @return
     * @throws Throwable
     */
    public static DictRight loadDictRightsData(DefaultContext ctx, String itemKey, long roleID, long operatorID) throws Throwable {
        DictRight dictRight=new DictRight();
        dictRight.setItemKey(itemKey);
        dictRight.setHasEmptRights(false);
        dictRight.setHasAllRights(false);
        IMetaFactory metaFactory = ctx.getVE().getMetaFactory();
        MetaDataObject metaDataObject = metaFactory.getDataObject(itemKey);
        String dbTable = metaDataObject.getMainTable().getBindingDBTableName();
        List<Object> args = new ArrayList<>();
        String sql ="SELECT OID,ParentId,Code,Name FROM " + dbTable + " WHERE 1=? ";
        args.add(1);
        List<Long> curDictRightOIDs =getDictOIDsByCurRight(ctx,dbTable);
        if(curDictRightOIDs.size()<=0){
            return dictRight;
        }
        Long fOID = curDictRightOIDs.get(0);
        //判断是否有全部权限
        if(fOID!=-1l){
            sql+=" AND OID IN("+StringUtils.join(Collections.nCopies(curDictRightOIDs.size(), "?"), ",")+")";
            args.addAll(curDictRightOIDs);
        }
        //查看可管控的字典数据
        DataTable dictDataDT = ctx.getDBManager().execPrepareQuery(sql,args);
        if (dictDataDT.size() > 0) {
            List<Long> rightDictIds =getDictOIDsByRoleOrOperator(ctx,dbTable,roleID,operatorID);
            //全部数据权限
            if(rightDictIds.contains(-1l)){
                dictRight.setHasAllRights(true);
            }
            //空值权限
            if(rightDictIds.contains(0l)){
                dictRight.setHasEmptRights(true);
            }
            dictRight.setDataList(new ArrayList<>());
            dictDataDT.beforeFirst();
            while (dictDataDT.next()) {
                DictRight.Data data=new  DictRight.Data();
                data.setParentId(dictDataDT.getLong("ParentId"));
                data.setOid(dictDataDT.getLong("OID"));
                data.setCode(dictDataDT.getString("Code"));
                data.setName(dictDataDT.getString("Name"));
                if(dictRight.isHasAllRights()||rightDictIds.contains(data.getOid())){
                    data.setDataRight(true);
                }else {
                    data.setDataRight(false);
                }
                dictRight.getDataList().add(data);
            }
        }
        return dictRight;
    }

    private static List<Long> getDictOIDsByRoleOrOperator(DefaultContext ctx, String dictTableName,long roleID, long operatorID) throws Throwable {
        DataTable dataTable=null;
        if(roleID>0l){
            dataTable= ctx.getDBManager().execPrepareQuery("SELECT DictID FROM "+dictTableName+"_RR WHERE RoleId=?",roleID);
        }else if(operatorID>0l){
            dataTable= ctx.getDBManager().execPrepareQuery("SELECT DictID FROM "+dictTableName+"_OR WHERE OperatorId=?",operatorID);
        }
        List<Long> dictIds=new ArrayList<>();
        if(dataTable!=null){
            dataTable.beforeFirst();
            while (dataTable.next()){
                dictIds.add(dataTable.getLong("DictID"));
            }
        }
        return dictIds;
    }

    private static List<Long> getDictOIDsByCurRight(DefaultContext ctx, String dictTableName) throws Throwable {
        List<Long> ids = new ArrayList<>();
        if (isAdmin(ctx)) {
            ids.add(-1l);
            return ids;
        }
        Env env = ctx.getEnv();
        Long userId = env.getUserID();
        //查询_or表
        DataTable dictDataDT = ctx.getDBManager().execPrepareQuery("SELECT DictID FROM " + dictTableName + "_OR WHERE OperatorID=?", userId);
        if (dictDataDT!=null && dictDataDT.size() > 0) {
            dictDataDT.beforeFirst();
            while (dictDataDT.next()) {
                Long dictID = dictDataDT.getLong("DictID");
                if (dictID == -1l) {
                    ids.clear();
                    ids.add(-1l);
                    return ids;
                }
                ids.add(dictID);
            }
        }
        List<Long> roleIDList = env.getRoleIDList();
        if (roleIDList != null && roleIDList.size() > 0) {
            List<Object> args=new ArrayList<>(roleIDList);
            //查询_rr表
            DataTable dictRoleRightDT = ctx.getDBManager().execPrepareQuery("SELECT DictID FROM " + dictTableName + "_RR WHERE RoleId IN ("+ StringUtils.join(Collections.nCopies(roleIDList.size(), "?"), ",")+")", args);
            if (dictRoleRightDT.size() > 0) {
                dictRoleRightDT.beforeFirst();
                while (dictRoleRightDT.next()) {
                    Long dictID = dictRoleRightDT.getLong("DictID");
                    if (dictID == -1l) {
                        ids.clear();
                        ids.add(-1l);
                        return ids;
                    }
                    ids.add(dictID);
                }
            }
        }
        return ids;
    }

    /**
     * 获取当前可配置权限(菜单,字典,单据)
     * 调用yigo现有服务
     * @param context
     * @return
     * @throws Throwable
     */
    public static SetRight getSetRightsData(DefaultContext context) throws Throwable {
        IServiceRequest req = new ServiceRequest(context.getEnv());
        req.getParameterMap().put("service", "SetRightsService");
        req.getParameterMap().put("cmd", "LoadSetRightsList");
        ServiceResponse resp = new ServiceResponse();
        ServiceUtil.createLocalDispatcher(req).processService(req, resp);
        JSONObject obj = (JSONObject) resp.getResult();
        JSONObject data = (JSONObject) obj.get("data");
        ObjectMapper m = new ObjectMapper();
        SetRight rightsData = m.readValue(data.toString(), SetRight.class);
        return rightsData;
    }

    /**
     * 根据当前document构建表单权限vo
     * @param document
     * @return
     */
    public static FormRight buildFormRightByDoc(Document document) {
        DataTable headDT = document.get("YES_RS_RightsSet");
        DataTable operationsDT = document.get("YES_RS_Operations");
        DataTable fieldRightsDT = document.get("YES_RS_FieldRights");
        FormRight formRight = new FormRight();
        if (headDT.first()) {
            formRight.setFormKey(headDT.getString("FormKey"));
            formRight.setHasAllEnableRights(headDT.getInt("All_IsEdit") == 1);
            formRight.setHasAllOptRights(headDT.getInt("All_O") == 1);
            formRight.setHasAllVisibleRights(headDT.getInt("All_IsVisible") == 1);
        }
        if (operationsDT != null) {
            formRight.setOpt(new ArrayList<>());
            operationsDT.beforeFirst();
            while (operationsDT.next()) {
                FormRight.Opt opt = new FormRight.Opt();
                opt.setId(operationsDT.getLong("OID"));
                opt.setParentId(operationsDT.getLong("ParentID"));
                opt.setName(operationsDT.getString("Name"));
                opt.setOptKey(operationsDT.getString("OptKey"));
                opt.setOpt(operationsDT.getInt("IsOpt") == 1);
                formRight.getOpt().add(opt);
            }
        }
        if (fieldRightsDT != null) {
            formRight.setField(new ArrayList<>());
            fieldRightsDT.beforeFirst();
            while (fieldRightsDT.next()) {
                FormRight.Field field = new FormRight.Field();
                field.setEdit(fieldRightsDT.getInt("IsEdit") == 1);
                field.setVisible(fieldRightsDT.getInt("IsVisible") == 1);
                field.setFieldKey(fieldRightsDT.getString("FieldKey"));
                field.setId(fieldRightsDT.getLong("OID"));
                field.setParentId(fieldRightsDT.getLong("ParentID"));
                field.setName(fieldRightsDT.getString("Name"));
                formRight.getField().add(field);
            }
        }
        return formRight;
    }

    /**
     * 根据当前document构建字典权限vo
     * @param document
     * @return
     */
    public static DictRight buildDictRightByDoc(Document document) {
        DataTable headDT = document.get("YES_RS_RightsSet");
        DataTable dataRigthsDT = document.get("YES_RS_DataRigths");
        DictRight dictRight = new DictRight();
        if (headDT.isFirst()) {
            dictRight.setItemKey(headDT.getString("ItemKey"));
            dictRight.setHasAllRights(headDT.getInt("All_DataRight") == 1);
            dictRight.setHasEmptRights(headDT.getInt("Is_Null") == 1);
        }
        if (dataRigthsDT.size() > 0) {
            dictRight.setDataList(new ArrayList<>());
            dataRigthsDT.beforeFirst();
            while (dataRigthsDT.next()) {
                DictRight.Data data = new DictRight.Data();
                data.setOid(dataRigthsDT.getLong("OID"));
                data.setParentId(dataRigthsDT.getLong("ParentId"));
                data.setCode(dataRigthsDT.getString("Code"));
                data.setName(dataRigthsDT.getString("Name"));
                data.setDataRight(dataRigthsDT.getInt("Is_DataRight") == 1);
                dictRight.getDataList().add(data);
            }
        }
        return dictRight;
    }


    /**
     * 字典权限数据填充到document
     * @param document
     * @param dictRight
     */
    public static void fillDictRight2Document(Document document, DictRight dictRight) {
        DataTable headDT = document.get("YES_RS_RightsSet");
        if(headDT.first()){
            headDT.setInt("All_DataRight", dictRight.isHasAllRights() ? 1 : 0);
            headDT.setInt("Is_Null", dictRight.isHasEmptRights() ? 1 : 0);
        }
        DataTable dictRightsDT = document.get("YES_RS_DataRigths");
        dictRightsDT.clear();
        if (dictRight.getDataList() != null) {
            for (DictRight.Data data : dictRight.getDataList()) {
                dictRightsDT.append();
                dictRightsDT.setString("Name", data.getName());
                dictRightsDT.setString("Code", data.getCode());
                dictRightsDT.setInt("Is_DataRight", data.isDataRight() ? 1 : 0);
                dictRightsDT.setLong("OID", data.getOid());
                dictRightsDT.setLong("ParentID", data.getParentId());
            }
        }
    }

    /**
     * 表单权限数据填充到document
     * @param document
     * @param formRight
     */
    public static void fillFormRight2Document(Document document, FormRight formRight) {
        DataTable headDT = document.get("YES_RS_RightsSet");
        DataTable operationsDT = document.get("YES_RS_Operations");
        DataTable fieldRightsDT = document.get("YES_RS_FieldRights");
        //head
        if(headDT.first()){
            headDT.setInt("All_IsEdit", formRight.isHasAllEnableRights() ? 1 : 0);
            headDT.setInt("All_O", formRight.isHasAllOptRights() ? 1 : 0);
            headDT.setInt("All_IsVisible", formRight.isHasAllVisibleRights() ? 1 : 0);
        }
        fieldRightsDT.clear();
        //fieldRightsDT
        if (formRight.getField() != null) {
            for (FormRight.Field field : formRight.getField()) {
                fieldRightsDT.append();
                fieldRightsDT.setInt("IsEdit", field.isEdit() ? 1 : 0);
                fieldRightsDT.setInt("IsVisible", field.isVisible() ? 1 : 0);
                fieldRightsDT.setString("FieldKey", field.getFieldKey());
                fieldRightsDT.setLong("OID", field.getId());
                fieldRightsDT.setLong("ParentID", field.getParentId());
                fieldRightsDT.setString("Name", field.getName());
            }
        }
        operationsDT.clear();
        if (formRight.getOpt() != null) {
            for (FormRight.Opt opt : formRight.getOpt()) {
                operationsDT.append();
                operationsDT.setInt("IsOpt", opt.isOpt() ? 1 : 0);
                operationsDT.setString("Name", opt.getName());
                operationsDT.setString("OptKey", opt.getOptKey());
            }
        }
    }

    public static void buildFormOptRightDT(List<RightUtil.FormRightsData.OptData> optDataList, DataTable optRightDT, Long parentID) {
        if (optDataList != null) {
            for (RightUtil.FormRightsData.OptData optData : optDataList) {
                long id = optData.getKey().hashCode();
                optRightDT.append();
                optRightDT.setLong("OID", id);
                optRightDT.setLong("ParentID", parentID);
                optRightDT.setString("OptKey", optData.getKey());
                optRightDT.setString("Name", optData.getCaption());
                optRightDT.setInt("IsOpt", optData.isHasRights() ? 1 : 0);
                if (optData.getItems() != null) {
                    buildFormOptRightDT(optData.getItems(), optRightDT, id);
                }
            }
        }
    }

    public static void buildFormFieldRightDT(List<RightUtil.FormRightsData.FieldData> fieldDataList, DataTable fieldRightDT, Long parentID) {
        if (fieldDataList != null) {
            for (RightUtil.FormRightsData.FieldData fieldData : fieldDataList) {
                long id = fieldData.getKey().hashCode();
                fieldRightDT.append();
                fieldRightDT.setLong("OID", id);
                fieldRightDT.setString("Name", fieldData.getCaption());
                fieldRightDT.setString("FieldKey", fieldData.getKey());
                fieldRightDT.setInt("IsVisible", fieldData.isVisible() ? 1 : 0);
                fieldRightDT.setInt("IsEdit", fieldData.isEnable() ? 1 : 0);
                fieldRightDT.setLong("ParentID", parentID);
                if (fieldData.getItems() != null) {
                    buildFormFieldRightDT(fieldData.getItems(), fieldRightDT, id);
                }
            }
        }
    }

    public static void buildEntryRightDT(List<RightUtil.SetRight.Entry> entries, DataTable entryRightDT, long parentID) {
        if (entries != null) {
            for (RightUtil.SetRight.Entry entry : entries) {
                long oid = entry.getKey().hashCode();
                entryRightDT.append();
                entryRightDT.setLong("OID", oid);
                entryRightDT.setLong("ParentID", parentID);
                entryRightDT.setString("EntryName", entry.getCaption());
                entryRightDT.setString("EntryKey", entry.getKey());
                if (entry.getItems() != null) {
                    buildEntryRightDT(entry.getItems(), entryRightDT, oid);
                }
            }
        }
    }

    public static void buildDictRightsDT(List<RightUtil.SetRight.Dict> dict, DataTable dictRightsDT) {
        for (RightUtil.SetRight.Dict d : dict) {
            dictRightsDT.append();
            dictRightsDT.setString("Name", d.getCaption());
            dictRightsDT.setString("DictKey", d.getKey());
        }
    }

    public static void buildBillRightsDT(List<RightUtil.SetRight.Form> forms, DataTable billRightsDT) {
        for (RightUtil.SetRight.Form form : forms) {
            billRightsDT.append();
            billRightsDT.setString("Name", form.getCaption());
            billRightsDT.setString("FormKey", form.getKey());
        }
    }

    /**
     * 菜单权限数据
     */
    public static class EntryRightData{
        private boolean allRights;
        private List<String> entryKeys;

        public boolean isAllRights() {
            return allRights;
        }

        public void setAllRights(boolean allRights) {
            this.allRights = allRights;
        }

        public List<String> getEntryKeys() {
            return entryKeys;
        }

        public void setEntryKeys(List<String> entryKeys) {
            this.entryKeys = entryKeys;
        }
    }
    /**
     * 表单权限
     */
    public static class FormRightsData {
        private boolean defStatus;
        private boolean hasAllEnableRights;
        private boolean hasAllOptRights;
        private boolean hasAllVisibleRights;
        private List<FieldData> fieldData;
        private List<OptData> optData;

        public boolean isDefStatus() {
            return defStatus;
        }

        public void setDefStatus(boolean defStatus) {
            this.defStatus = defStatus;
        }

        public boolean isHasAllEnableRights() {
            return hasAllEnableRights;
        }

        public void setHasAllEnableRights(boolean hasAllEnableRights) {
            this.hasAllEnableRights = hasAllEnableRights;
        }

        public boolean isHasAllOptRights() {
            return hasAllOptRights;
        }

        public void setHasAllOptRights(boolean hasAllOptRights) {
            this.hasAllOptRights = hasAllOptRights;
        }

        public boolean isHasAllVisibleRights() {
            return hasAllVisibleRights;
        }

        public void setHasAllVisibleRights(boolean hasAllVisibleRights) {
            this.hasAllVisibleRights = hasAllVisibleRights;
        }

        public List<FieldData> getFieldData() {
            return fieldData;
        }

        public void setFieldData(List<FieldData> fieldData) {
            this.fieldData = fieldData;
        }

        public List<OptData> getOptData() {
            return optData;
        }

        public void setOptData(List<OptData> optData) {
            this.optData = optData;
        }

        public static class FieldData {
            private String caption;
            private boolean enable;
            private String key;
            private boolean visible;
            private List<FieldData> items;

            public String getCaption() {
                return caption;
            }

            public void setCaption(String caption) {
                this.caption = caption;
            }

            public boolean isEnable() {
                return enable;
            }

            public void setEnable(boolean enable) {
                this.enable = enable;
            }

            public String getKey() {
                return key;
            }

            public void setKey(String key) {
                this.key = key;
            }

            public boolean isVisible() {
                return visible;
            }

            public void setVisible(boolean visible) {
                this.visible = visible;
            }

            public List<FieldData> getItems() {
                return items;
            }

            public void setItems(List<FieldData> items) {
                this.items = items;
            }
        }

        public static class OptData {
            private String caption;
            private boolean hasRights;
            private String key;
            private List<OptData> items;

            public String getCaption() {
                return caption;
            }

            public void setCaption(String caption) {
                this.caption = caption;
            }

            public boolean isHasRights() {
                return hasRights;
            }

            public void setHasRights(boolean hasRights) {
                this.hasRights = hasRights;
            }

            public String getKey() {
                return key;
            }

            public void setKey(String key) {
                this.key = key;
            }

            public List<OptData> getItems() {
                return items;
            }

            public void setItems(List<OptData> items) {
                this.items = items;
            }
        }
    }

    /**
     * 当前可配置的权限
     */
    public static class SetRight {
        private List<Dict> dict;
        private List<Form> form;
        private List<Entry> entry;
        private Object custom;

        public List<Dict> getDict() {
            return dict;
        }

        public void setDict(List<Dict> dict) {
            this.dict = dict;
        }

        public List<Form> getForm() {
            return form;
        }

        public void setForm(List<Form> form) {
            this.form = form;
        }

        public List<Entry> getEntry() {
            return entry;
        }

        public void setEntry(List<Entry> entry) {
            this.entry = entry;
        }

        public Object getCustom() {
            return custom;
        }

        public void setCustom(Object custom) {
            this.custom = custom;
        }

        public static class Dict {
            private String caption;
            private Integer secondaryType;
            private String key;

            public String getCaption() {
                return caption;
            }

            public void setCaption(String caption) {
                this.caption = caption;
            }

            public Integer getSecondaryType() {
                return secondaryType;
            }

            public void setSecondaryType(Integer secondaryType) {
                this.secondaryType = secondaryType;
            }

            public String getKey() {
                return key;
            }

            public void setKey(String key) {
                this.key = key;
            }
        }

        public static class Form {
            private String caption;
            private Object serviceRights;
            private String key;

            public String getCaption() {
                return caption;
            }

            public void setCaption(String caption) {
                this.caption = caption;
            }

            public Object getServiceRights() {
                return serviceRights;
            }

            public void setServiceRights(Object serviceRights) {
                this.serviceRights = serviceRights;
            }

            public String getKey() {
                return key;
            }

            public void setKey(String key) {
                this.key = key;
            }
        }

        public static class Entry {
            private String caption;
            private List<Entry> items;
            private String key;
            private String rightsRelation;
            private String formCaption;
            private String formKey;

            public String getCaption() {
                return caption;
            }

            public void setCaption(String caption) {
                this.caption = caption;
            }


            public List<Entry> getItems() {
                return items;
            }

            public void setItems(List<Entry> items) {
                this.items = items;
            }

            public String getKey() {
                return key;
            }

            public void setKey(String key) {
                this.key = key;
            }

            public String getRightsRelation() {
                return rightsRelation;
            }

            public void setRightsRelation(String rightsRelation) {
                this.rightsRelation = rightsRelation;
            }

            public String getFormCaption() {
                return formCaption;
            }

            public void setFormCaption(String formCaption) {
                this.formCaption = formCaption;
            }

            public String getFormKey() {
                return formKey;
            }

            public void setFormKey(String formKey) {
                this.formKey = formKey;
            }
        }
    }
}
