import "./modulepreload-polyfill-7faf532e.js";
import { w as webFormRender } from "./web-form-render-8318eb6a.js";
import { q as ExceptionStack, bD as YesCore, U as Utils, bx as afterYIUILoad, bA as AppSetting } from "./yes-core-636cc260.js";
import { M as MainFrame } from "./index-4bc641ea.js";
import "./yes-ui-c6bba9c4.js";
import "./vendor-e1ca6068.js";
customElements.define("form-viewer", webFormRender);
window.addEventListener("error", function(e) {
  ExceptionStack.push(e.error);
});
window.addEventListener("unhandledrejection", function(e) {
  ExceptionStack.push(e.reason);
});
window.YIUI = {
  ...window.YIUI || {},
  YesCore,
  APP: {
    MainFrame
  },
  Utils
};
afterYIUILoad();
AppSetting.updateClientSetting("yescore.component.grid.defaultCustom", false);
AppSetting.updateClientSetting("yescore.component.grid.defaultZoom", true);
AppSetting.updateClientSetting("yescore.component.dict.EditType", 0);
AppSetting.updateClientSetting("yescore.dialog.Placement", "right");
AppSetting.updateClientSetting("yescore.component.base.CompStyle", "innerLabel");
AppSetting.updateClientSetting("yescore.component.grid.restoreInitStatus", true);
const formViewerElm = document.createElement("form-viewer");
const embedByEntryKey = async (entryKey2) => {
  if (!entryKey2)
    return;
  const entryData = await MainFrame.getEntryData();
  const entryItem = Utils.findMatchingNodes(entryData.entry, (item) => item.key === entryKey2)[0];
  if (entryItem) {
    const _formKey = entryItem.formKey;
    formViewerElm.dataset.formkey = _formKey;
    const parameters = entryItem.parameters;
    if (parameters && typeof parameters === "string" && parameters.includes("=")) {
      const _parameters = {};
      parameters.split(";").forEach((item) => {
        let attr = item.split("=");
        _parameters[attr[0]] = attr[1];
      });
      formViewerElm.parameters = _parameters;
    }
  }
};
const embedByFormKey = (formKey2) => {
  if (!formKey2)
    return;
  formViewerElm.dataset.formkey = formKey2;
  urlSearchParams.oid && (formViewerElm.dataset.oid = urlSearchParams.oid + "");
};
const getUrlSearchParams = () => {
  const urlSearch = new URLSearchParams(window.location.search);
  let result = {};
  for (let key of urlSearch.keys()) {
    result[key] = urlSearch.get(key);
  }
  return result;
};
const urlSearchParams = getUrlSearchParams();
const { formKey, entryKey } = urlSearchParams;
if (entryKey) {
  (async () => {
    await embedByEntryKey(entryKey);
  })();
} else if (formKey) {
  embedByFormKey(formKey);
}
formViewerElm.parameters = Object.assign(formViewerElm.parameters || {}, urlSearchParams, { customOnLoad: true });
document.body.appendChild(formViewerElm);
//# sourceMappingURL=form_viewer-a1e931e2.js.map
