/**
 * 加载ux
 */
const uxInit = async () => {
    const loader = await import("./ux-loader/index.js");
    const { currentPage } = await import("./util/util.js");

    const clientSettings = window.YigoClassicUxSetting?.clientSettings;
    if (clientSettings) {
        window.addEventListener("YIUI-loaded", e => {
            for (let key in clientSettings) {
                try {
                    // 处理 Object、Boolean、Number、Array 等类型 如："true" --> true, `["a","b"]` --> ["a","b"] 等
                    clientSettings[key] = JSON.parse(clientSettings[key]);
                } catch (error) {
                    // 是纯字符串，如"left"、"right"，则不作处理
                }
                YIUI.AppSetting.updateClientSetting(key, clientSettings[key]);
            }
        });
    }

    let showPage = function () {
        if (currentPage.isMainFrame()) { // 主页，加载Navbar
            loader.loadNavbar();
        }

        document.querySelector('body').classList.remove('pageHide'); // 显示
    }

    if (window.YigoClassicUxSetting) { // 有YigoUX
        // 加载主题
        let loadThemeResult = loader.loadTheme(
            YigoClassicUxSetting.themeOption,
            YigoClassicUxSetting.avaliableThemes,
            YigoClassicUxSetting.additionalThemeVariables,
            YigoClassicUxSetting.extendThemeCssUrls
        );

        loader.decorateSite(YigoClassicUxSetting.siteDecoration);
        let isLogin = currentPage ? currentPage.isLogin()
            : document.querySelector("html").getAttribute('data-page') == 'login';
        if (isLogin) { //处理Login界面
            await loader.decorateLogin(YigoClassicUxSetting.loginDecoration);
        } else { //处理 Yigo 主界面
            await loader.decorateMainFrame(YigoClassicUxSetting.mainFrameDecoration);
        }

        //应用主题
        if (loadThemeResult) {
            await loader.applyTheme(showPage);
        } else {
            showPage();
        }

        //同步主题到 cookie, 这样登录一次后, 下次就会记住用户的设置(用于登录界面)
        window.dispatchEvent(new CustomEvent('YIUI-ux-theme-changed', {
            detail: {
                themeOption: YigoClassicUxSetting.themeOption
            }
        }));
    } else { // 无YigoUX
        showPage();
    }
};

function getUXWebRoot() {
    return './yesui/';
}

export {
    uxInit
}
