(async () => {
    const { default: elmUtil } = await import("../../ux/util/elmUtils.js");
    var isDev;
    window.addEventListener("YIUI-loaded", e => {
        isDev = YIUI.AppSetting.isDev;

        if (isDev) {
            history.pushState({}, "", location.origin + location.search + location.hash);
        }
    });


    window.addEventListener("YES-APP-Login-page-loaded", async () => {
        const { uxInit } = await import("../../ux/load-ux.js");
        await uxInit();

        document.querySelector('.login-main').style.display = 'flex';
        document.querySelector('.waitting-box').style.display = 'none';
    });

    const oLoginbox = document.querySelector(".login-loginbox"),
        oUsername = document.querySelector(".login-username"),
        oShowSwitch = document.querySelector(".show-switch"),
        oLoginBtn = document.querySelector(".login-button"),
        oErrorInfo = document.querySelector(".login-info.error");
    let def, username;

    loadRely(async ()=>{
        def = await YIUI.SvrMgr.getLoginDef();
        await Promise.all([
            setLanguage(def),
            setValid(def),
        ]);
        setSession(def);
        window.dispatchEvent(new CustomEvent("YES-APP-Login-page-loaded"));
        let usernameInput = document.querySelector('.login-username');
        usernameInput && usernameInput.focus()
    })

    function loadRely(readyCallback){
        window.addEventListener("YIUI-loaded", e => {
            readyCallback();
        });
    }
    const setSession = (def) => {
        if (!def || !(def.sessionPara || def.paras)) return;
        const oCombox = document.createElement("div");
        oCombox.innerHTML =
            '<div class="login_paras login-combox-content">' +
            '<span class="login-combox-name"></span>' +
            '<p><span class="login-combox-value">请选择</span></p>' +
            "</div>" +
            '<div class="login_sel_vw">' +
            '<ul class="login-combox-list"></ul>' +
            "</div>";
        oCombox.classList.add("login_org", "login-combox");

        oLoginbox.insertBefore(oCombox, oErrorInfo);
        const oName = oCombox.querySelector(".login-combox-name");

        if (def.paras) {
            var paras = def.paras,
                p;
            for (var i = 0; (p = paras[i]); i++) {
                oCombox.setAttribute("para-key", p.paraKey);
                oCombox.setAttribute("provider", p.provider);

                oName.innerHTML = p.paraTitle || "组织机构";
                addEvent(oCombox);
            }
        } else {
            oCombox.setAttribute("para-key", def.sessionParaKey || "orgID");
            oCombox.setAttribute("provider", def.provider);

            oName.innerHTML = def.sessionParaTitle || "组织机构";
            addEvent(oCombox);
        }

        function addEvent(container) {
            var oVw = container.querySelector(".login_sel_vw");
            container
                .querySelector(".login_paras")
                .addEventListener("click", function (e) {
                    slideToggle(oVw);
                    e.stopPropagation();
                });
        }
    };

    function slideToggle(node) {
        let isShow = getComputedStyle(node).display !== "none",
            fn = () => elmUtil.slideUp(node);

        if (isShow) {
            fn();
            document.removeEventListener("click", fn);
        } else {
            elmUtil.slideDown(node);
            document.addEventListener("click", fn);
        }
    }

    const setLanguage = async (def) => {
        const oLocale = document.querySelector(".login_locale");

        if (!def || !def.multiLang) return oLocale.remove();

        oLocale.style.display = "block";
        const supportLang = await YIUI.SvrMgr.getSupportLang(),
            { items } = supportLang,
            oUl = oLocale.querySelector(".locale-combox-list");

        if (!supportLang || !items || !items.length) return;
        const language = setLang(items),
            oParas = oLocale.querySelector(".locale_paras"),
            oVw = oLocale.querySelector(".login_locale_vw"),
            oLocaleVal = oParas.querySelector(".locale-combox-value");
        const oLocaleContent = oLocale.querySelector(".locale-combox-content");

        const _doSetLang = (lang, caption) => {
            oLocaleVal.setAttribute("value", lang);
            oLocaleVal.innerHTML = caption;
            oLocaleContent.classList.add('select');
        }

        items.forEach((item) => {
            addLangItem(item);
            // 注销后显示上次登录语言
            if (item.value === language) {
                _doSetLang(item.value, item.caption);
            }
        });

        // 若 Cookies 的 locale 拿不到，navigator.language 也拿不到，或者拿到了但是 (supportLang)items 里不包含, 则默认取 items[0] 作为默认语言
        if(!oLocaleVal.getAttribute("value") && items.length){
            _doSetLang(item[0].value, item[0].caption);
        }

        const docClickHandle = () => {
            elmUtil.slideUp(oVw);
            document.removeEventListener("click", docClickHandle);
        };

        oParas.addEventListener("click", (e) => {
            slideToggle(oVw);
            e.stopPropagation();
        });

        oVw.addEventListener("click", function (e) {
            e.stopPropagation();
            var target = e.target.closest("li");
            if (!target) return;
            if (target.classList.contains("sel")) {
                return;
            }
            var sel = oVw.querySelector(".sel");
            sel && sel.classList.remove("sel");
            target.classList.add("sel");
            const caption = target.innerHTML,
                value = target.getAttribute("value");
            oLocaleVal.setAttribute("value", value);
            oLocaleVal.innerHTML = caption;
            setLocaleToCookie(value);
            oVw.style.display = "none";
        });

        function addLangItem(item) {
            const { value, caption } = item,
                oLi = document.createElement("li");
            oLi.setAttribute("value", value);
            oLi.classList.add("login-combox-item");

            if (value === language) {
                oLi.classList.add("sel");
            }

            oLi.innerHTML = caption;
            oUl.appendChild(oLi);
        }

        function setLang(supportLangs) {
            let origLocale = YIUI.CookiesUtil.get("locale");
            let locale = origLocale;
            if (!locale) {
                locale = navigator.language || navigator.userLanguage || "zh-CN";
                if (locale.includes("-")) {
                    locale = locale.toLowerCase();
                    const idx = locale.indexOf("-");
                    locale =
                        locale.substring(0, idx) +
                        "-" +
                        locale.substring(idx + 1).toUpperCase();
                }
            }

            // 如果实时获取到的 language (比如 "zh" ) 不在 supportLang 语言列表里, 则直接给其赋值为 "zh-CN"
            if (!supportLangs.some(i => i.value === locale)) {
                locale = "zh-CN";
            }
            (origLocale != locale) && YIUI.CookiesUtil.set("locale", locale, isDev ? '/' : '');

            return locale;
        }
    };

    async function refreshValidateCode() {
        const oImg = document.querySelector(".login-valid-rows .login_valid_img");
        let id = YIUI.CookiesUtil.get("tmpClientID");
        if (!id) {
            id = await YIUI.SvrMgr.getTmpClientID();
            YIUI.CookiesUtil.set("tmpClientID", id);
        }
        const { result } = await YIUI.SvrMgr.validateImage({ tmpclientid: id });
        oImg.setAttribute("src", "data:image/png;base64," + result);
        document.querySelector(".login-valid").value = '';
    }

    const setValid = (def) => {
        const oValid = document.querySelector(".login-valid-rows");
        if (!def || !def.valid) {
            return oValid.remove();
        }

        oValid.style.display = "block";
        const oImg = oValid.querySelector(".login_valid_img");
        refreshValidateCode();
        oImg.addEventListener("click", refreshValidateCode);
    };

    const getValidateCode = () =>
        def && def.valid
            ? document.querySelector(".login-valid").value
            : "";

    const userChange = () => {
        let _value = oUsername.value;
        if (username == _value || _value == "") {
            return;
        } else {
            username = _value;
        }
        var oOrgs = document.querySelectorAll(".login_org");
        oOrgs.forEach((org) => {
            addSessionItems(org, username, getSessionParas());
        });
    };

    const addSessionItems = async (elm, user, sessionParas) => {
        var data = {
            user: user,
            provider: elm.getAttribute("provider"),
            paras: sessionParas,
        };

        var oVw = elm.querySelector(".login_sel_vw"),
            oUl = oVw.querySelector("ul.login-combox-list");

        oUl.innerHTML = "";

        var oCmb = elm.querySelector(".login_paras .login-combox-value");
        oCmb.innerHTML = "";
        oCmb.setAttribute("value", null);

        var result = await YIUI.SvrMgr.loadSessionParaItems(data);
        if (!result || isEmpty(result)) {
            oVw.classList.add("empty");
            return;
        }

        var item, oLi;

        for (var i = 0; (item = result.items[i]); i++) {
            oLi = document.createElement("li");
            oLi.classList.add("login-combox-item");
            oLi.setAttribute("value", item.value);
            oLi.innerHTML = item.caption;
            oLi.addEventListener("click", (e) => clickHandler(oLi));
            oUl.appendChild(oLi);
        }

        function clickHandler(elm) {
            var oSel = oVw.querySelector(".login_sel_vw .sel");
            if (oSel) {
                oSel.classList.remove("sel");
            }
            elm.classList.add("sel");
            var caption = elm.innerHTML,
                value = elm.getAttribute("value"),
                oldVal = oCmb.getAttribute("value");
            var fireEvent = false;

            if (value != oldVal && getComputedStyle(oVw).display == 'none') {
                fireEvent = true;
            }

            oCmb.innerHTML = caption;
            oCmb.setAttribute("value", value);
            oVw.style.display = 'none';
            if (fireEvent) {
                var divs = document.querySelectorAll(".login_org");
                if (!divs.length) {
                    return;
                }
                var index = getIndex(divs[0]);
                divs.forEach(function (elm, i) {
                    if (i > index) {
                        addSessionItems(elm, username, getSessionParas());
                    }
                });
            }

        }
        oUl.querySelector(".login-combox-item").click();
    };

    var getSessionParas = function () {
        var paras = {};
        var oOrgs = document.querySelectorAll(".login_org");
        oOrgs.forEach((org) => {
            var value = org
                .querySelector(".login_paras .login-combox-value")
                .getAttribute("value");
            if (value != null) {
                var paraKey = org.getAttribute("para-key");
                paras[paraKey] = value;
            }
        });

        return paras;
    };

    oUsername.addEventListener("blur", () => userChange());

    oShowSwitch.addEventListener("click", function (event) {
        this.classList.toggle("closed");
        var password = document.querySelector(".login-password");
        if (this.classList.contains("closed")) {
            password.setAttribute("type", "password");
        } else {
            password.setAttribute("type", "text");
        }
    });

    oLoginBtn.addEventListener("click", function () {
        var username = oUsername.value,
            password = document.querySelector(".login-password").value,
            validateCode = getValidateCode(),
            tmpClientID = YIUI.CookiesUtil.get("tmpClientID");

        YIUI.SvrMgr.doLogin(username, password, {}, validateCode, tmpClientID).then(
            (ret) => {
                if (ret) {
                    //跳转
                    location.href = location.href.replace("login.html", "");
                }
            },
            (err) => {
                def && def.valid && refreshValidateCode()
                let errorInfo = document.querySelector(".login-info.error");
                const message = YIUI.ErrorUtil.getErrorMessage(err);
                errorInfo.classList.add("visible");
                errorInfo.querySelector("span").innerText = message.message;
            }
        );
    });

    document.querySelectorAll("input").forEach((node) => {
        node.addEventListener("keyup", (e) => {
            if (e.keyCode == 13) {
                node.blur();
                oLoginBtn.click();
            }
        });
    });

    function setLocaleToCookie(val) {
        if (YIUI.CookiesUtil.get("locale") !== val) {
            YIUI.CookiesUtil.set("locale", val , isDev?'/':'');
        }
    }

    function isEmpty(obj) {
        for (var key in obj) {
            return false;
        }
        return true;
    }

    const getIndex = (elm) => {
        let i = 0;
        while (elm.previousElementSibling) {
            elm = elm.previousElementSibling;
            i++;
        }
        return i;
    };
})();
