(function() {
	RTS = RTS || {};
	RTS.Dict_Right = function() {
		var options = RTS.options;
		var dr_opt = {
			theme : 'default',
			expandLevel : 1,
			beforeExpand : function(node) {
		    	var def = $.Deferred();
				var id = node.attr('id');
				var expanded = node.attr('expanded');
				if(expanded) {
					return def.promise();
				}
				var _this = this;
				var parentID = id;
				var operatorID = options.tag == RTS.Custom_tag.OperatorRights ? options.id : -1;
				var roleID = options.tag == RTS.Custom_tag.RoleRights ? options.id : -1;
				return RTS.Service.dictExpand(operatorID, roleID, options.itemKey, parentID).then(function(newData) {
					var $dr_tbl = RTS.dictRight.$table._table;
					var dictData = newData.data;
					var item = $dr_tbl.treeNode.tree[id];
					var changed = item.changed;
					var checked = false;
					
					var data = {
						rows: dictData,
						cols: [{
								key: "code",
								caption: RTS.I18N.getString("RIGHTSSET_CODE","编码")
							}, {
								key: "name",
								caption: RTS.I18N.getString("CURRENCY_NAME","名称")
							}, {
								key: "hasRead",
								type: "checkbox",
								index: 0,
								caption: RTS.I18N.getString("CURRENCY_HASREAD","可见")
							}, {
                                key: "hasWrite",
                                type: "checkbox",
								index: 1,
                                caption: RTS.I18N.getString("CURRENCY_HASWRITE","可编辑")
                            }],
						hasAllRights: newData.hasAllRights
					}
					
					var table = new RTS.Treetable(null, RTS.options);
					var rows = table.createRows($dr_tbl, data, id);
					$dr_tbl.addChilds(rows);
					node.attr("expanded", "expanded");
					if(changed) {
						checked = $(".checkbox", node).is(":checked");
						if(dictData.length > 0) {
							for (var i = 0, len = dictData.length; i < len; i++) {
								var $id = dictData[i].oid;
								var $item = $dr_tbl.treeNode.tree[$id];
								var hasRts = dictData[i].hasRights == 0 ? false : true;
								$item.changed = true;
								if(hasRts != checked) {
									if(checked) {
										$(".checkbox", $item.row).prop("checked", true);
										options.dict.addRts.push($id);
									} else {
										$(".checkbox", $item.row).prop("checked", false);
										options.dict.delRts.push($id);
									}
								}
							}
						}
					}
				});
			},
			onSelect : function($table, $tr) {
				var node_current = $table.treeNode.tree[$tr.attr("id")];
				var target = $table.target;
				var modifyIndex = target.attr("index")||0;
				if(!target.hasClass("checkbox")) return;
				var checked = target.is(":checked");
				
				var checkTitleTr = function(tr) {
					var chks = $(".checkbox:not([enable='false'])", tr);
					options.dict.allRead = chks[0].checked || false;
					options.dict.emptyRts = chks[1].checked || false;
					options.dict.allWrite = chks[2].checked || false;
					options.dict.$table = $table;
				};
				var checkPtr = function(node, index, checked) {
						var p_node = node.parentNode();
						if(!p_node) return;
						var hasChanged = isCheckChanged(p_node, index);
						if(hasChanged) {
							p_node.changed = true;
						}
						if(checked) {
							p_node.checked = checked;
						}
						if(p_node.parentNode()) {
							checkPtr(p_node.parentNode(), index, checked);
						}
					};

					var checkCtr = function(node, index, checked) {
						var childs = node.children, c_node;
						for (let i = 0; i < childs.length; i++) {
							c_node = childs[i];
							if(!c_node) return;
							var hasChanged = isCheckChanged(c_node, index);
							if(hasChanged) {
								c_node.changed = true;
								if(c_node.children.length > 0) {
									checkCtr(c_node, index, checked)
								}
							}
						}
					};

					var isCheckChanged = function(node, index) {
						var $chk = $(".checkbox:not([class~='ignore'])", node.row).eq(index);
							var hasread = node.row.attr("hasread") == "true" ? true : false;
							var hasWrite = node.row.attr("hasWrite") == "true" ? true : false;
							var hasChanged = false;
							if(index == 0) {
								hasChanged = (hasread != $chk.is(":checked"));
							} else if(index == 1) {
								hasChanged = (hasWrite != $chk.is(":checked"));
							}
							return hasChanged;
					};
				
				var chk = $(".checkbox", $tr);
				var readIndex;
				var WriteIndex;
				var checkedRead;
				var checkedWrite;
				if(chk.length==2){//表示点击了下面的选项
					readIndex=0;
					WriteIndex=1;
	                checkedRead =chk[readIndex].checked;
	                checkedWrite = chk[WriteIndex].checked;
				} else if(chk.length>2) {
					readIndex=0;
					WriteIndex=2;
					checkedRead = chk[readIndex].checked;
	                checkedWrite = chk[WriteIndex].checked;
				}
			
				var $trs = $("tr:not([class~='title'])", $table);
				if(target.parents("tr").hasClass("title")) {
					for (var i = 0, len = $trs.length; i < len; i++) {
						var $tr = $trs.eq(i);
						if(modifyIndex == 0) {
							$chk = $(".checkbox:not([class~='ignore'])", $tr).eq(0);
							if($chk.length == 0 || $chk.attr("enable") == "false") continue;
							$chk.prop("checked", checkedRead);
							if(!checkedRead) {
								$(".checkbox:not([class~='ignore'])", $tr).eq(1).prop("checked", false);
								chk.eq(WriteIndex).prop("checked",false);

							}
						}
						if(modifyIndex==1) {
							$chk = $(".checkbox:not([class~='ignore'])", $tr).eq(1);
							if($chk.length == 0 || $chk.attr("enable") == "false") continue;
							$chk.prop("checked", checkedWrite);
							if(checkedWrite){
								$(".checkbox:not([class~='ignore'])", $tr).eq(0).prop("checked", true);
								chk.eq(readIndex).prop("checked",true);
							}
						}
						var tr = $chk.parents("tr").eq(0);
						RTS.setRts(tr.attr("id"), checked, $table);
						var allReadRts = chk.eq(0);
						var ignore = chk.eq(1);
						var allWriteRts = chk.eq(2);
						var isReadAllCk = allReadRts.is(":checked");
						var isWriteAllCk = allWriteRts.is(":checked");
						var ignoreAllCk = ignore.is(":checked");
						allRts = isReadAllCk&&isWriteAllCk&&ignoreAllCk;
						if(allRts){
							options.dict.allRights = true;
							options.dict.saveType = 1;
						} else {
							if(!allRts && options.dict.allRights){
								options.dict.allRights = false;
								options.dict.saveType = -1;
							}
						}
					}
				} else{
					var tr = target.parents("tr").eq(0);
					RTS.setRts(tr.attr("id"), checked, $table);
					var chks =  $(".t-hdiv tr.title .checkbox", $table.parents(".rts-tbl")), childs;
					var $trs = $("tr:not([class~='title'])", $table);
					var allRts = true;
					var allReadRts = chks.eq(0);
					var ignore = chks.eq(1);
					var allWriteRts = chks.eq(2);

								var childsWrite = $(".checkbox[index='1'].checkbox:not([enable='false']):not([class ~='ignore'])", $trs);
								var childsRead = $(".checkbox:not([index]):not([enable='false']):not([class ~='ignore'])", $trs);
					function VisibleFalse(tr,value) {
						//子节点处理
						let id = tr.attr("id");
							let $1 = $("tr[pid='" + id + "']", $table);
							let $input = $("input.checkbox", tr);
							$.each($input, function (index, checkbox) {
								$(checkbox).prop("checked", value)
							})
						if (tr.attr("haschild") == 'true') {
							$.each($1, function (index, trs) {
								VisibleFalse($(trs),value);
							})
							}
						}
					
					function pVisibleFalse(tr){
						if (tr.attr("pid")){
							var visiblevalue = false;
							var enablevalue = false;
							let $pid = $("tr[pid='"+tr.attr("pid")+"']", $table);
							let $pinput = $("input.checkbox", $pid);
							for (let i = 0; i < $pinput.length; i++) {
								if (i % 2 ===0){
									var  in2 = $pinput[i];
									if($(in2).is(":checked")){
										visiblevalue = true;
										break;
									}
								}
								
							}
							for (let i = 0; i < $pinput.length; i++) {
								if (i % 2 !==0){
									var  in2 = $pinput[i];
									if($(in2).is(":checked")){
										enablevalue = true;
										break;
									}
								}
								
							}
							let $1 = $("tr[id='"+tr.attr("pid")+"']", $table);
							let $input = $("input.checkbox", $1);
							$.each($input,function (index,checkbox) {
								if (index % 2 !==0){
									$(checkbox).prop("checked",enablevalue);
								} else {
											$(checkbox).prop("checked",visiblevalue);
								}
							})
							pVisibleFalse($1);
					}
					}
					function VisibleTrue(tr,value) {
						//子节点处理
						let id = tr.attr("id");
						let $1 = $("tr[pid='" + id + "']", $table);
						let $input = $("input.checkbox", tr).eq(0);
						$input.prop("checked",value)
						if (tr.attr("haschild") == 'true') {
						
							$.each($1, function (index, trs) {
								VisibleTrue($(trs),value);
							})
						}
					}
					function pVisibleTrue(tr){
						if (tr.attr("pid")){
							var value = false;
							let $pid = $("tr[pid='"+tr.attr("pid")+"']", $table);
							let $pinput = $("input.checkbox", $pid);
							for (let i = 0; i < $pinput.length; i++) {
								if (i % 2 ===0){
									var  in2 = $pinput[i];
									if($(in2).is(":checked")){
										value = true;
										break;
									}
								}
							}
							let $1 = $("tr[id='"+tr.attr("pid")+"']", $table);
							let $input = $("input.checkbox", $1).eq(0);
							$input.prop("checked",value)
							pVisibleTrue($1);
						}
					}

					function EnableFalse(tr,value) {
						//子节点处理
						let id = tr.attr("id");
							let $1 = $("tr[pid='" + id + "']", $table);
							let $input = $("input.checkbox", tr).eq(1);
							$input.prop("checked",value);
						if (tr.attr("haschild") == 'true') {
							
							$.each($1, function (index, trs) {
								EnableFalse($(trs),value);
							})
						}
					}
					
					function pEnableFalse(tr){
						if (tr.attr("pid")){
							var value = false;
							let $pid = $("tr[pid='"+tr.attr("pid")+"']", $table);
							let $pinput = $("input.checkbox", $pid);
							for (let i = 0; i < $pinput.length; i++) {
								if (i % 2 !==0){
									var  in2 = $pinput[i];
									if($(in2).is(":checked")){
										value = true;
										break;
									}
								}
								
							}
							let $1 = $("tr[id='"+tr.attr("pid")+"']", $table);
							let $input = $("input.checkbox", $1).eq(1);
							$input.prop("checked",value);
							pEnableFalse($1);
						}
					}
					function EnableTrue(tr,value) {
						//子节点处理
						let id = tr.attr("id");
							let $1 = $("tr[pid='" + id + "']", $table);
							let $input = $("input.checkbox", tr);
							$.each($input, function (index, checkbox) {
								$(checkbox).prop("checked", value)
							});
						if (tr.attr("haschild") == 'true') {
							
							$.each($1, function (index, trs) {
								EnableTrue($(trs),value);
							})
						}
					}
					
					function pEnableTrue(tr){
						if (tr.attr("pid")){
							var enablevalue = false;
							var visiblevalue = false;
							let $pid = $("tr[pid='"+tr.attr("pid")+"']", $table);
							let $pinput = $("input.checkbox", $pid);
							for (let i = 0; i < $pinput.length; i++) {
								if (i % 2 !==0){
									var  in2 = $pinput[i];
									if($(in2).is(":checked")){
										enablevalue = true;
										break;
									}
								}
							}
							for (let i = 0; i < $pinput.length; i++) {
								if (i % 2 ==0){
									var  in2 = $pinput[i];
									if($(in2).is(":checked")){
										visiblevalue = true;
										break;
									}
								}
							}
							let $1 = $("tr[id='"+tr.attr("pid")+"']", $table);
							let $input = $("input.checkbox", $1);
							$.each($input,function (index,checkbox) {
								if (index % 2 !==0){
									$(checkbox).prop("checked",enablevalue)
								}else{
									$(checkbox).prop("checked",visiblevalue)
								}
								
							})
							pEnableTrue($1);
						}
					}
					if(modifyIndex==0){//勾选可见
						if(!$(target).is(":checked")){//勾选false
							var index = childsRead.index(target);
							childsWrite.eq(index).prop("checked",false);
							allWriteRts.prop("checked",false);
							allReadRts.prop("checked",false);
							//父节点处理
							pVisibleFalse(tr);
							//子节点处理
							VisibleFalse(tr,false);
						}else {
							//父节点处理
							pVisibleTrue(tr);
							//子节点处理
							VisibleTrue(tr,true);
						}
					}else{
						if($(target).is(":checked")){//勾选True
							var index = childsWrite.index(target);
							childsRead.eq(index).prop("checked",true);
							//父节点处理
							pEnableTrue(tr)
							//子节点处理
							EnableTrue(tr,true);
						} else {
							allWriteRts.prop("checked",false);
							var readAllCk = true;
							for (var j = 0; j < childsRead.length; j++) {
								var cked = childsRead.eq(j).is(":checked");
								if(!cked) readAllCk = false;
							}
							if (!readAllCk){
								allReadRts.prop("checked",readAllCk);
							}
							//父节点处理
							pEnableFalse(tr)
							//子节点处理
							EnableFalse(tr,false);
						}
					}
					var isReadAllCk = allReadRts.is(":checked");
					var isWriteAllCk = allWriteRts.is(":checked");
					var ignoreAllCk = ignore.is(":checked");
					allRts = isReadAllCk&&isWriteAllCk&&ignoreAllCk;
					if(allRts){
						options.dict.allRights = true;
						options.dict.saveType = 1;
					} else {
						if(!allRts && options.dict.allRights){
							options.dict.allRights = false;
							options.dict.saveType = -1;
						}
					}

				}
				if(node_current) {
					checkCtr(node_current, modifyIndex, checked);
					checkPtr(node_current, modifyIndex, checked);
					if(!target.parents("tr").hasClass("title")) {
						var node = $table.treeNode.tree[$tr.attr("id")];
						RTS.setRts($tr.attr("id"), checked, $table);
						var p_tr = target.parents("tr");
						if(p_tr.eq(0).hasClass("title")) {
							checkTitleTr(p_tr);
						} else {
							var p_tr = $table.parent().prev();
							checkTitleTr(p_tr);
						}
							
					}
				} else {
					var p_tr = $table.parent().prev();
					checkTitleTr(p_tr);
				}
			}
		};

		var getChainDictData = function(itemKey, pageNum, fuzzyValue) {
			var startRow = pageNum * options.maxRows;
			var maxRows = options.maxRows;
			var pageIndicatorCount = options.pageIndicatorCount;
			var operatorID = options.tag == RTS.Custom_tag.OperatorRights ? options.id : -1;
			var roleID = options.tag == RTS.Custom_tag.RoleRights ? options.id : -1;
			return RTS.Service.getChainDictData(operatorID, roleID, itemKey, startRow, maxRows, pageIndicatorCount, fuzzyValue).then(function(chainData) {
				var data = {
					rows: chainData.data,
					cols: [{
							key: "code",
							caption: RTS.I18N.getString("RIGHTSSET_CODE","编码")
						}, {
							key: "name",
							caption: RTS.I18N.getString("CURRENCY_NAME","名称")
						}, {
                            key: "hasRead",
                            type: "checkbox",
							index: 0,
                            caption: RTS.I18N.getString("CURRENCY_HASREAD","可见")
                        }, {
                             key: "hasWrite",
                             type: "checkbox",
							index: 1,
                             caption: RTS.I18N.getString("CURRENCY_HASWRITE","可编辑")
                         }],
					hasAllRights: chainData.hasAllRights,
					totalRowCount: chainData.totalRowCount
				}
				return data;
			});
		}
		var rt = {
				el: $("<div class='dict'><div class='rts-dict-right'></div></div>"),
				isChain: false,
				itemKey: null,
				map: {},
				render: function(ct) {
					this.el.appendTo(ct);
					this.install();
				},
				empty: function() {
					this.$table && this.$table.removeAll();
					$(".rts-dict-right", this.el).empty();
				},
				addRows: function(newData) {
					// options.dict.reset = function() {
					// 	var tree = this.$table.treeNode.tree;
					// 	for(var key in tree) {
					// 		tree[key].changed = false;
					// 	}
					// }
					this.map = {};
					if(!newData) return;
					var $el = this.el;
					var tbl = null;
					if(this.isChain) {
						this.empty();
						$el.removeClass("normal");
						if($(".fuzzy", $el).length == 0) {
							var html = "<div class='fuzzy'>" +
											"<span class='rts-txted'><input type='text' placeholder='请输入关键字'/></span>" +
											"<button class='rts-btn'></button>" +
										"</div>";
							$el.prepend(html);
						}
						var count = newData.rows.length;
						var itemKey = this.itemKey;
				    	var _this = this;
						this.needResize = true;
						if(count != 0){
						var page = $(".rts-dict-right", $el).pagination({
							pageSize: options.maxRows,
							//总记录数
					        totalNumber: count,
					        showPages: true,
					        showPageDetail: false,
					        showFirstButton: false,
					        showLastButton: false,
					        pageIndicatorCount: options.pageIndicatorCount,
					        pageChanges: function(pageNum) {
								var fuzzyVal = $(".fuzzy input", $el).val();
								var content = this.content;
								var _page = this;
								
								var tbl2 = _this.map[pageNum];
								if(!tbl2) {
									getChainDictData(itemKey, pageNum, fuzzyVal).then(function(data) {
										options.dictRts = [];
										_this.$table_el = tbl.create(dr_opt, data);
										_this.map[pageNum] = _this.$table_el;
											tbl.$table_el = _this.$table_el;
										page.setTotalRowCount(pageNum*options.maxRows + data.totalRowCount);
										if(_this.needResize) {
											_this.resize(_this.el.width(), _this.el.height());
											_this.needResize = true;
										}
									});
								} else {
										$(".rts-dict-right .paginationjs-content .t-bdiv", _this.el).empty().append(tbl2);
									_this.$table_el = tbl2;
										tbl.$table_el = _this.$table_el;
										tbl.refreshCheck();
										if(options.modify){
											RTS.dictRight.setEnable(true);
										}else{
											RTS.dictRight.setEnable(false);
										}
								}
					        }
						});
						$el = page.content;
						tbl = new RTS.Treetable($el, options);
						this.pagination = page;
				    	var pagesH = $(".paginationjs-pages", $el).is(":hidden") ? 0 : $(".paginationjs-pages", $el).outerHeight();
				    	var realHeight = $el.height() - pagesH;
				    	page.content.css("height", realHeight);
				        options.setTotalRowCount = function(pageNum, totalRowCount) {
							page.setTotalRowCount(totalRowCount);
				        };
					} else {
							tbl = new RTS.Treetable($(".rts-dict-right", $el), options);
							this.$table_el = tbl.create(dr_opt, newData);
						}
						
					} else {
						$el.addClass("normal");
						$(".fuzzy", $el).remove();
						tbl = new RTS.Treetable($(".rts-dict-right", $el), options);
						this.$table_el = tbl.create(dr_opt, newData);
					}
					this.$table = tbl;
					this.resize(this.el.width(), this.el.height());
					tbl.isChain = this.isChain;
					options.dictRts = [];
				},
				setEnable: function(enable) {
					if(!this.$table) return;
					var chks = $(".checkbox:not([class~='ignore'])", this.el);
					if(enable) {
						chks.removeAttr("disabled");
					} else {
						chks.attr("disabled", "disabled");
					}
				},
				resize: function(width, height) {
					this.el.width(width).height(height);
					var content = $(".rts-dict-right", this.el);
					var fuzzy = $(".fuzzy", this.el);
					var t_h = height;
					if(fuzzy.length > 0) {
						var c_height = height - fuzzy.outerHeight(true);
						content.outerHeight(t_h);
				    	var pagesH = $(".paginationjs-pages", content).outerHeight();
				    	t_h = c_height - pagesH;
				    	$(".paginationjs-content", content).css("height", t_h);
					} else {
						content.outerHeight(height);
					}
					this.$table && this.$table.resize(width, t_h);
				},
				install: function() {
					var $el = this.el;
					var _this = this;
					$el.delegate(".fuzzy .rts-btn", "click", function() {
						var isChain = options.clickTr.attr("secondaryType") == 5;
						if(isChain) {
//							$el = $(".paginationjs-content", $el);
							var pageNum = 0;
							var value = $(".fuzzy input", $el).val().toLowerCase();
							getChainDictData(options.itemKey, pageNum, value).then(function(data) {
								_this.$table && _this.$table.removeAll();
								options.dictRts = [];
								_this.$table_el = _this.$table.create(dr_opt, data);
//								_this.$table = tbl;
								_this.pagination.setTotalRowCount(pageNum*options.maxRows + data.totalRowCount);
								if(_this.needResize) {
									_this.resize(_this.el.width(), _this.el.height());
									_this.needResize = true;
								}
							});
						} else {
							RTS.loopSearch(value, _this.$table_el);
						}
					});
				}
		};
		
		return rt;
	}
})();
