/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.init;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.init.MidSystemInit;
import com.bokesoft.yes.mid.base.CoreSetting;
import com.bokesoft.yes.mid.base.SvrInfo;
import com.bokesoft.yes.mid.hotdeploy.MidPluginManager;
import com.bokesoft.yes.mid.module.ServiceModuleManager;
import com.bokesoft.yes.mid.servlet.provider.ServiceProvider;
import com.bokesoft.yigo.mid.scheduler.QuartzManager;
import com.bokesoft.yigo.mid.service.provider.ServiceProviderFactory;
import com.bokesoft.yigo.mid.util.MD5Generator;
import java.net.URL;
import java.net.URLDecoder;
import javax.servlet.ServletContext;

public class BootApp {
    private boolean inDependent = true;

    public void stop(ServletContext servletContext) {
        try {
            QuartzManager.getInstance().shutdown();
            MidPluginManager.deleteTmp();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void start(ServletContext object) {
        try {
            Object object2 = Thread.currentThread().getContextClassLoader().getResource("core.properties");
            if (object2 == null) {
                throw new RuntimeException("missing core");
            }
            object2 = URLDecoder.decode(((URL)object2).getPath(), "utf-8");
            SvrInfo.setWorkDir((String)((String)object2).substring(0, ((String)object2).lastIndexOf(47) + 1));
            object = object.getRealPath("/");
            SvrInfo.setAppPath((String)object);
            new MidSystemInit().init();
            if (!CoreSetting.getInstance().getSolutionPath().equals("jar")) {
                MD5Generator.generateServerAppMD5((String)object);
            }
            BootApp.registerServiceProvider();
            BootApp.registerModule();
            LogSvr.getInstance().info("System initialize sucessfully.");
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            LogSvr.getInstance().error("System initialize failed.", throwable2);
            throw new RuntimeException(throwable2);
        }
    }

    private static void registerServiceProvider() {
        ServiceProviderFactory.registerProvider((Object[][])ServiceProvider.getServices());
    }

    private static void registerModule() {
        new ServiceModuleManager().init();
    }

    public boolean isInDependent() {
        return this.inDependent;
    }

    public void setInDependent(boolean bl) {
        this.inDependent = bl;
    }

    public void resetGlobalResources() {
    }
}

