package com.bokesoft.yes.mid.web.ui.load.viewcollection;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutWizardItem;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaWizardLayout;
import com.bokesoft.yigo.tools.ve.VE;

public class WizardLayoutJSONBuilder extends AbstractJSONBuilder<MetaWizardLayout> {

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaWizardLayout meta) throws Throwable {
		json.put(JSONConstants.COMMON_TYPE, LayoutType.toString(meta.getLayoutType()));

		JSONArray itemArray = new JSONArray();
		Iterator<MetaLayoutWizardItem> it = meta.iterator();
		while (it.hasNext()) {
			MetaLayoutWizardItem metaLayoutWizardItem = it.next();
			JSONObject itemObj = new JSONObject();
			JSONHelper.writeToJSON(itemObj, JSONConstants.COMMON_KEY, metaLayoutWizardItem.getKey(), "");
			JSONHelper.writeToJSON(itemObj, JSONConstants.COMMON_CAPTION, metaLayoutWizardItem.getCaption(), "");
			itemArray.put(itemObj);
		}

		json.put(JSONConstants.COMMON_ITEMS, itemArray);
	}
}
