package com.bokesoft.yes.mid.web.ui.load.viewcollection;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaTableRowLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaTableViewLayout;
import com.bokesoft.yigo.tools.ve.VE;

public class TableViewLayoutJSONBuilder extends AbstractJSONBuilder<MetaTableViewLayout> {

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaTableViewLayout meta) throws Throwable {
		json.put(JSONConstants.COMMON_TYPE, LayoutType.toString(meta.getLayoutType()));

		if (meta.getRowCollection() != null && meta.getRowCollection().size() > 0) {
			JSONArray itemArray = new JSONArray();
			Iterator<MetaTableRowLayout> it = meta.getRowCollection().iterator();
			while (it.hasNext()) {
				MetaTableRowLayout metaTableRowLayout = it.next();
				JSONObject itemObj = new JSONObject();
				DefSize width = metaTableRowLayout.getWidth();
				DefSize height = metaTableRowLayout.getHeight();
				JSONHelper.writeToJSON(itemObj, JSONConstants.COMMON_WIDTH, width == null ? "" : width.toString(), "");
				JSONHelper.writeToJSON(itemObj, JSONConstants.COMMON_HEIGHT, height == null ? "" : height.toString(), "");
				JSONHelper.writeToJSON(itemObj, JSONConstants.COMMON_WEIGHT, metaTableRowLayout.getWeight() + "", "");
				itemArray.put(itemObj);
			}
			json.put(JSONConstants.COMMON_ITEMS, itemArray);
		}
	}
}
