package com.bokesoft.yes.mid.web.ui.load.viewcollection;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaFluidTableLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutColumn;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutRowIndex;
import com.bokesoft.yigo.tools.ve.VE;

public class FluidTableLayoutJSONBuilder extends AbstractJSONBuilder<MetaFluidTableLayout> {

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaFluidTableLayout meta) throws Throwable {
		json.put(JSONConstants.COMMON_TYPE, LayoutType.toString(meta.getLayoutType()));
		JSONHelper.writeToJSON(json, JSONConstants.FLUIDTABLELAYOUTPANEL_REPEATCOUNT, meta.getRepeatCount(), 1);
		JSONHelper.writeToJSON(json, JSONConstants.FLUIDTABLELAYOUTPANEL_REPEATGAP, meta.getRepeatGap(), 0);
		JSONHelper.writeToJSON(json, JSONConstants.FLUIDTABLELAYOUTPANEL_COLUMNGAP, meta.getColumnGap(), 0);
		JSONHelper.writeToJSON(json, JSONConstants.FLUIDTABLELAYOUTPANEL_ROWGAP, meta.getRowGap(), 0);
		JSONHelper.writeToJSON(json, JSONConstants.FLUIDTABLELAYOUTPANEL_ROWHEIGHT, meta.getRowHeight(), 0);

		if (meta.getColumnCollection() != null && meta.getColumnCollection().size() > 0) {
			JSONArray widthArray = new JSONArray();
			Iterator<MetaLayoutColumn> it = meta.getColumnCollection().iterator();
			while (it.hasNext()) {
				MetaLayoutColumn metaLayoutColumn = it.next();
				DefSize width = metaLayoutColumn.getWidth();
				widthArray.put(width == null ? JSONObject.NULL : width.toString());
			}
			json.put(JSONConstants.FLUIDTABLELAYOUTPANEL_WIDTHS, widthArray);
		}

		JSONArray itemArray = new JSONArray();
		Iterator<MetaLayoutRowIndex> it = meta.iterator();
		while (it.hasNext()) {
			MetaLayoutRowIndex metaLayoutRowIndex = it.next();
			JSONObject rowIndexObj = new JSONObject();
			JSONHelper.writeToJSON(rowIndexObj, JSONConstants.COMMON_KEY, metaLayoutRowIndex.getKey(), "");
			itemArray.put(rowIndexObj);
		}

		json.put(JSONConstants.COMMON_ITEMS, itemArray);
	}

}
