package com.bokesoft.yes.mid.web.ui.load.panel.gridpanel;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaRowDef;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaRowDefCollection;
import com.bokesoft.yigo.tools.ve.VE;

public class RowDefCollectionJSONBuilder extends AbstractJSONBuilder<MetaRowDefCollection>{

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder,
			JSONObject json, MetaForm metaForm, MetaRowDefCollection meta) throws Throwable {
		
		JSONHelper.writeToJSON(json, JSONConstants.GRIDLAYOUTPANEL_ROWGAP, meta.getRowGap(), 0 );
		JSONHelper.writeToJSON(json, JSONConstants.GRIDLAYOUTPANEL_ROWHEIGHT, meta.getRowHeight(), 0 );
		
		Iterator<MetaRowDef> itRowDef = meta.iterator();
		MetaRowDef metaRowDef = null;
		JSONArray rows = new JSONArray();
		Object height = null;
		while (itRowDef.hasNext()) {
			metaRowDef = itRowDef.next();
			height = meta.getRowHeight();
			JSONObject rowDefJSON = builder.build(ve, builder, metaForm, metaRowDef);
			if(!rowDefJSON.isNull(JSONConstants.COMMON_HEIGHT)) {
				height = rowDefJSON.get(JSONConstants.COMMON_HEIGHT);
			}
			rows.put(height);
		}
		json.put(JSONConstants.GRIDLAYOUTPANEL_HEIGHTS, rows);
	}

}
