package com.bokesoft.yes.mid.web.ui.load.panel.gridpanel;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDef;
import com.bokesoft.yigo.tools.ve.VE;

public class ColumnDefJSONBuilder extends AbstractJSONBuilder<MetaColumnDef> {

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder,
			JSONObject json, MetaForm metaForm, MetaColumnDef meta) throws Throwable {

		DefSize width = meta.getWidth();
		if (width != null) {
			if (width.getSizeType() == DefSize.Fix) {
				JSONHelper.writeToJSON(json, JSONConstants.COMMON_WIDTH, width.getSize(), 0);
			} else if (width.getSizeType() == DefSize.Ratio) {
				JSONHelper.writeToJSON(json, JSONConstants.COMMON_WIDTH, width.toString(), "0");
			} else if (width.getSizeType() == DefSize.Auto || width.getSizeType() == DefSize.Pref) {
				JSONHelper.writeToJSON(json, JSONConstants.COMMON_WIDTH, width.toString(), "0");
			}
		}

		DefSize minWidth = meta.getMinWidth();
		if (minWidth != null) {
			if (minWidth.getSizeType() == DefSize.Fix) {
				JSONHelper.writeToJSON(json, JSONConstants.COMMON_MINWIDTH, minWidth.getSize(), 0);
			} else if (minWidth.getSizeType() == DefSize.Ratio) {
				JSONHelper.writeToJSON(json, JSONConstants.COMMON_MINWIDTH, minWidth.toString(), "0");
			} else if (minWidth.getSizeType() == DefSize.Pref) {
				JSONHelper.writeToJSON(json, JSONConstants.COMMON_MINWIDTH, DefSize.STR_Pref, "");
			}
		}		
	}
}
