package com.bokesoft.yes.mid.web.ui.load.panel.gridpanel;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDef;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDefCollection;
import com.bokesoft.yigo.tools.ve.VE;

public class ColumnDefCollectionJSONBuilder extends AbstractJSONBuilder<MetaColumnDefCollection> {

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder,
			JSONObject json, MetaForm metaForm, MetaColumnDefCollection meta) throws Throwable {

		JSONHelper.writeToJSON(json, JSONConstants.GRIDLAYOUTPANEL_COLUMNGAP, meta.getColumnGap(), 0 );
		
		Iterator<MetaColumnDef> itColumnDef = meta.iterator();
		MetaColumnDef metaColumnDef = null;
		JSONArray widths = new JSONArray();
		JSONArray minWidths = new JSONArray();
		Object width = null;
		Object minWidth = -1;
		while (itColumnDef.hasNext()) {
			metaColumnDef = itColumnDef.next();
			JSONObject columnDefJSON = builder.build(ve, builder, metaForm, metaColumnDef);
			if(!columnDefJSON.isNull(JSONConstants.COMMON_WIDTH)) {
				width = columnDefJSON.get(JSONConstants.COMMON_WIDTH);
			} else {
				width = null;
			}
			widths.put(width);
			if(!columnDefJSON.isNull(JSONConstants.GRIDLAYOUTPANEL_MINWIDTH)) {
				minWidth = columnDefJSON.get(JSONConstants.GRIDLAYOUTPANEL_MINWIDTH);
			} else {
				minWidth = -1;
			}
			minWidths.put(minWidth);
		}
		json.put(JSONConstants.GRIDLAYOUTPANEL_WIDTHS, widths);
		json.put(JSONConstants.GRIDLAYOUTPANEL_MINWIDTHS, minWidths);
	}
}
