package com.bokesoft.yes.mid.web.ui.load.panel;

import java.util.Iterator;

import com.bokesoft.yigo.meta.form.component.panel.MetaSplitSizeCollapaseTypeEnum;
import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BasePanelJSONBuilder;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.MetaSplitPanel;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutSplitItem;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaSplitLayout;
import com.bokesoft.yigo.tools.ve.VE;

public class SplitPanelJSONBuilder extends BasePanelJSONBuilder<MetaSplitPanel> {

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaSplitPanel meta) throws Throwable {
		super.load(ve, builder, json, metaForm, meta);
		json.put(JSONConstants.BASEPANEL_LAYOUT, LayoutType.STR_LAYOUT_SPLIT);

		MetaSplitLayout layoutImpl = meta.newLayout();
		MetaComponent metaComponent = null;
		Iterator<MetaLayoutSplitItem> it = layoutImpl.iterator();
		MetaLayoutSplitItem item = null;
		JSONArray items = new JSONArray();
		JSONArray splitSizes = new JSONArray();
		JSONObject childJSON = null;
		JSONObject size = null;
		while (it.hasNext()) {
			item = it.next();
			size = new JSONObject();
			metaComponent = meta.getComponent(item.getKey());
			childJSON = builder.build(ve, builder, metaForm, metaComponent);
			items.put(childJSON);

			DefSize defSize = item.getSize();
			if(defSize != null){
				if (defSize.getSizeType() == DefSize.Fix) {
					JSONHelper.writeToJSON(size, JSONConstants.SPLITSIZE_SIZE, defSize.getSize(), 0);
				} else if (defSize.getSizeType() == DefSize.Ratio) {
					JSONHelper.writeToJSON(size, JSONConstants.SPLITSIZE_SIZE, defSize.toString(), "0");
				} else {
					JSONHelper.writeToJSON(size, JSONConstants.SPLITSIZE_SIZE, defSize.toString(), "");
				}
			}

			JSONHelper.writeToJSON(size, JSONConstants.SPLITPANEL_FORWARD_COLLAPASED, item.getForwardCollapased(), false);
			JSONHelper.writeToJSON(size, JSONConstants.SPLITPANEL_REVERSE_COLLAPASED, item.getReverseCollapased(), false);
			JSONHelper.writeToJSON(size, JSONConstants.SPLITPANEL_TYPE, MetaSplitSizeCollapaseTypeEnum.getNameByType(item.getType()), "None");


			size.put(JSONConstants.SPLITSIZE_LOCK, false);
			splitSizes.put(size);
		}
		if (splitSizes.length() > 0) {
			json.put(JSONConstants.SPLITPANEL_SPLITSIZES, splitSizes);
		}

		int orientation = layoutImpl.getOrientation();
		String orientationStr = "horizontal";
		if (orientation == OrientationType.Vertical) {
			orientationStr = "vertical";
		}
		JSONHelper.writeToJSON(json, JSONConstants.SPLITPANEL_ORIENTATION, orientationStr, "");
		json.put(JSONConstants.COMMON_ITEMS, items);
	}
}
