package com.bokesoft.yes.mid.web.ui.load.panel;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BasePanelJSONBuilder;
import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.MetaColumnLayoutPanel;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaColumnLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutSpan;
import com.bokesoft.yigo.tools.ve.VE;

public class ColumnLayoutPanelJSONBuilder extends BasePanelJSONBuilder<MetaColumnLayoutPanel> {

	@Override
	public void load(VE ve,
			IRootJSONBuilder<AbstractMetaObject> builder,
			JSONObject json, MetaForm metaForm, MetaColumnLayoutPanel meta)
			throws Throwable {
		super.load(ve, builder, json, metaForm, meta);
		json.put(JSONConstants.BASEPANEL_LAYOUT, LayoutType.STR_LAYOUT_COLUMN);

		MetaColumnLayout layoutImpl = meta.newLayout();
		int componentCount = meta.getComponentCount();
		MetaComponent metaComponent = null;
		JSONArray items = new JSONArray();
		JSONObject childJSON = null;
		for ( int i = 0; i<componentCount; ++i ) {
			metaComponent = meta.getComponent(i);
			childJSON = builder.build(ve, builder, metaForm, metaComponent);
			MetaLayoutSpan layoutItem = layoutImpl.get(metaComponent.getKey());
			if(layoutItem != null) {
				JSONHelper.writeToJSON(childJSON, JSONConstants.COMMON_X, metaComponent.getX(), -1);
				JSONHelper.writeToJSON(childJSON, JSONConstants.COMMON_Y, metaComponent.getY(), -1);
				JSONHelper.writeToJSON(childJSON, JSONConstants.COMMON_COLSPAN, metaComponent.getXSpan(), 1);
				JSONHelper.writeToJSON(childJSON, JSONConstants.COMMON_ROWSPAN, metaComponent.getYSpan(), 1);
				items.put(childJSON);
			}
		}
		json.put(JSONConstants.COMMON_ITEMS, items);
	}

}
