package com.bokesoft.yes.mid.web.ui.load.control.tabgroup;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BaseComponentJSONBuilder;
import com.bokesoft.yigo.common.def.DirectionType;
import com.bokesoft.yigo.common.def.TabMode;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaFont;
import com.bokesoft.yigo.meta.form.component.MetaFormat;
import com.bokesoft.yigo.meta.form.component.control.MetaTabGroup;
import com.bokesoft.yigo.meta.form.component.control.MetaTabItem;
import com.bokesoft.yigo.tools.ve.VE;

public class TabGroupJSONBuilder extends BaseComponentJSONBuilder<MetaTabGroup> {

	@Override
	public JSONObject getMetaJSON(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, MetaForm metaForm,
			MetaTabGroup meta) throws Throwable {
		JSONObject metaJSON = super.getMetaJSON(ve, builder, metaForm, meta);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.TABGROUP_DIRECTION, DirectionType.toString(meta.getDirection()),
				DirectionType.STR_BOTTOM);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.TABGROUP_INDICATORCOLOR, meta.getIndicatorColor(), "");
		if (meta.getIndicatorHeight() != null) {
			JSONHelper.writeToJSON(metaJSON, JSONConstants.TABGROUP_INDICATORHEIGHT,
					meta.getIndicatorHeight().toString(), "");
		}
		JSONHelper.writeToJSON(metaJSON, JSONConstants.TABGROUP_TABMODE, TabMode.toString(meta.getTabMode()),
				TabMode.STR_Fixed);
		JSONArray items = new JSONArray();
		for (int i = 0; i < meta.getItemCollection().size(); i++) {
			MetaTabItem metaTabItem = meta.getItemCollection().get(i);
			JSONObject metaItemObject = new JSONObject();
			JSONHelper.writeToJSON(metaItemObject, JSONConstants.COMMON_KEY, metaTabItem.getKey(), "");
			JSONHelper.writeToJSON(metaItemObject, JSONConstants.COMMON_TEXT, metaTabItem.getText(), "");
			JSONHelper.writeToJSON(metaItemObject, JSONConstants.COMMON_ICON, metaTabItem.getIcon(), "");
			JSONHelper.writeToJSON(metaItemObject, JSONConstants.COMMON_FORMKEY, metaTabItem.getFormKey(), "");
			JSONHelper.writeToJSON(metaItemObject, JSONConstants.TABGROUP_ITEM_SELECTEDICON, metaTabItem.getSelectedIcon(), "");
			JSONHelper.writeToJSON(metaItemObject, JSONConstants.TABGROUP_ITEM_CLICKANIM, metaTabItem.getClickAnim(), "");
			JSONHelper.writeToJSON(metaItemObject, JSONConstants.COMMON_VISIBLE, metaTabItem.getVisible(), "");
			JSONHelper.writeToJSON(metaItemObject, JSONConstants.COMMON_VISIBLEDEPENDENCY, metaTabItem.getVisibleDependency(), "");
			JSONHelper.writeToJSON(metaItemObject, JSONConstants.COUNTDOWNVIEW_ONCLICK,
					metaTabItem.getAction() == null ? "" : metaTabItem.getAction().getContent(), "");
			
			MetaFormat formatMeta = metaTabItem.getFormat();
			JSONObject formatJSON = new JSONObject();
			if (formatMeta != null) {
				JSONHelper.writeToJSON(formatJSON, JSONConstants.FORMAT_FORECOLOR, formatMeta.getForeColor(), "");
				JSONHelper.writeToJSON(formatJSON, JSONConstants.FORMAT_BACKCOLOR, formatMeta.getBackColor(), "");
				JSONHelper.writeToJSON(formatJSON, JSONConstants.FORMAT_HIGHLIGHTBACKCOLOR,
						formatMeta.getHighlightBackColor(), "");
				JSONHelper.writeToJSON(formatJSON, JSONConstants.FORMAT_HALIGN, formatMeta.getHAlign(), -1);
				JSONHelper.writeToJSON(formatJSON, JSONConstants.FORMAT_VALIGN, formatMeta.getVAlign(), -1);
				JSONObject fontJSON = new JSONObject();
				MetaFont fontMeta = formatMeta.getFont();
				if (fontMeta != null) {
					JSONHelper.writeToJSON(fontJSON, JSONConstants.FONT_NAME, fontMeta.getName(), "");
					JSONHelper.writeToJSON(fontJSON, JSONConstants.FONT_SIZE, fontMeta.getSize(), -1);
					JSONHelper.writeToJSON(fontJSON, JSONConstants.FONT_BOLD, fontMeta.isBold(), false);
					JSONHelper.writeToJSON(fontJSON, JSONConstants.FONT_ITALIC, fontMeta.isItalic(), false);
				}
				formatJSON.put(JSONConstants.FORMAT_FONT, fontJSON);
			}
			metaItemObject.put(JSONConstants.COMMON_FORMAT, formatJSON);
			
			items.put(metaItemObject);
		}
		metaJSON.put(JSONConstants.TABGROUP_ITEMS, items);
		return metaJSON;
	}
}
