package com.bokesoft.yes.mid.web.ui.load.control.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.PropertiesJSONBuilder;
import com.bokesoft.yigo.common.def.SelectEditType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTimePickerProperties;
import com.bokesoft.yigo.tools.ve.VE;

public class TimePickerPropertiesJSONBuilder extends PropertiesJSONBuilder<MetaTimePickerProperties>{

	@Override
	protected void loadImpl(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaTimePickerProperties meta, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.TIMEPICKER_FORMATSTR, meta.getDateFormat(), "yyyy-MM");
		JSONHelper.writeToJSON(json, JSONConstants.TIMEPICKER_SECOND, meta.isSecond(), false);
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_PROMPTTEXT, meta.getPromptText(), "");
		JSONHelper.writeToJSON(json, JSONConstants.TIMEPICKER_EDITTYPE, SelectEditType.format(meta.getEditType()), SelectEditType.STR_POP);
		
	}

	

}
