package com.bokesoft.yes.mid.web.ui.load.control.properties;

import java.math.BigDecimal;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.PropertiesJSONBuilder;
import com.bokesoft.yigo.common.def.StepEditorEditType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaStepEditorProperties;
import com.bokesoft.yigo.tools.ve.VE;

public class StepEditorPropertiesJSONBuilder extends PropertiesJSONBuilder<MetaStepEditorProperties> {

	@Override
	protected void loadImpl(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaStepEditorProperties meta, String key) throws Throwable {

//		JSONHelper.writeToJSON(json, JSONConstants.STEPEDITOR_MAXVALUE, meta.getMaxValue().toString(),
//				new BigDecimal(Long.MAX_VALUE).toString());
//		JSONHelper.writeToJSON(json, JSONConstants.STEPEDITOR_MINVALUE, meta.getMinValue().toString(),
//				new BigDecimal(Long.MIN_VALUE).toString());
		
		json.put(JSONConstants.STEPEDITOR_MINVALUE, meta.getMinValue().toString());
		json.put(JSONConstants.STEPEDITOR_MAXVALUE, meta.getMaxValue().toString());
		
		JSONHelper.writeToJSON(json, JSONConstants.STEPEDITOR_STEP, meta.getStep().toString(),
				BigDecimal.ONE.toString());
		JSONHelper.writeToJSON(json, JSONConstants.STEPEDITOR_EDITTYPE, StepEditorEditType.format(meta.getEditType()),
				StepEditorEditType.STR_INPUT);
		JSONHelper.writeToJSON(json, JSONConstants.STEPEDITOR_SHOWTYPE, meta.getShowType(), 0);

	}
}
