package com.bokesoft.yes.mid.web.ui.load.control.properties;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.PropertiesJSONBuilder;
import com.bokesoft.yigo.common.def.ComboBoxSourceType;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.common.def.ParameterSourceType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.commondef.MetaStatus;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;
import com.bokesoft.yigo.meta.dataobject.MetaParameter;
import com.bokesoft.yigo.meta.dataobject.MetaParameterCollection;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaListBoxItemCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSegmentedControlProperties;
import com.bokesoft.yigo.meta.paratable.MetaParaGroup;
import com.bokesoft.yigo.meta.paratable.MetaParaItem;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.tools.ve.VE;

public class SegmentedControlPropertiesJSONBuilder extends PropertiesJSONBuilder<MetaSegmentedControlProperties>{

	@Override
	protected void loadImpl(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaSegmentedControlProperties meta, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMBOBOX_EDITABLE, meta.isEditable(), false);
		JSONHelper.writeToJSON(json, JSONConstants.COMBOBOX_ITEMS_DEPENDENCY, meta.getItemsDependency(), "");

		JSONHelper.writeToJSON(json, JSONConstants.COMBOBOX_GROUPKEY, meta.getGroupKey(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMBOBOX_GLOBALITEMS, meta.getGlobalItems(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMBOBOX_INTEGERVALUE, meta.isIntegerValue(), false);
		
		JSONArray itemsArry = new JSONArray();
		int sourceType = meta.getSourceType();
		JSONHelper.writeToJSON(json, JSONConstants.COMBOBOX_SOURCETYPE, sourceType, ComboBoxSourceType.ITEMS);

		switch(sourceType){
			case ComboBoxSourceType.ITEMS:
				MetaListBoxItemCollection metaItems = meta.getItems();
				if(metaItems != null){
					Iterator<MetaDefaultItem> it = metaItems.iterator();
					MetaDefaultItem metaItem = null;
					while ( it.hasNext() ) {
						metaItem = it.next();
						JSONObject itemJSON = new JSONObject();
						JSONHelper.writeToJSON(itemJSON, JSONConstants.COMMON_KEY, metaItem.getKey(), "");
						
						String caption = builder.getString(GroupKeyTable.STR_ITEMS, key , "Item-"+metaItem.getKey(), metaItem.getCaption());
						JSONHelper.writeToJSON(itemJSON, JSONConstants.COMMON_CAPTION, caption,"");
						JSONHelper.writeToJSON(itemJSON, JSONConstants.COMMON_VALUE, metaItem.getValue(),"");
						itemsArry.put(itemJSON);
					}
				}
			break;
			case ComboBoxSourceType.STATUS: 

				MetaStatusCollection statusCollection = MetaUtil.getStatusCollection(ve.getMetaFactory(),metaForm.getDataSource().getDataObject());
				
				if (statusCollection != null) {
					Iterator<MetaStatus> it = statusCollection.iterator();
					MetaStatus metaStatus = null;
					while (it.hasNext()) {
						metaStatus = it.next();
						JSONObject itemJSON = new JSONObject();
						JSONHelper.writeToJSON(itemJSON, JSONConstants.COMMON_KEY, metaStatus.getKey(), "");
						
						String caption = builder.getString(GroupKeyTable.STR_STATUS, "", metaStatus.getKey(), metaStatus.getCaption());	
						JSONHelper.writeToJSON(itemJSON, JSONConstants.COMMON_CAPTION, caption, "");
						JSONHelper.writeToJSON(itemJSON, JSONConstants.COMMON_VALUE, metaStatus.getValue(), Integer.MIN_VALUE);
						itemsArry.put(itemJSON);
					}
				}
			break;
			case ComboBoxSourceType.PARAGROUP: 
				String groupKey = meta.getGroupKey();

				MetaParaGroup metaParaGroup = MetaUtil.getParaGroup(ve.getMetaFactory(), groupKey);
				if( metaParaGroup != null ) {
					Iterator<MetaParaItem> it = metaParaGroup.iterator();
					MetaParaItem metaParaItem = null;
					while (it.hasNext()) {
						metaParaItem = it.next();
						JSONObject paraJSON = new JSONObject();
						JSONHelper.writeToJSON(paraJSON, JSONConstants.COMMON_KEY, metaParaItem.getKey(), "");
						
						String caption = builder.getString(GroupKeyTable.STR_PARAS, metaParaGroup.getKey(), metaParaItem.getKey(), metaParaItem.getCaption());
						JSONHelper.writeToJSON(paraJSON, JSONConstants.COMMON_CAPTION, caption, "");
						JSONHelper.writeToJSON(paraJSON, JSONConstants.COMMON_VALUE, metaParaItem.getValue(), "");
						itemsArry.put(paraJSON);
					}
				}
			break;
		}
//		if(itemsArry.length() > 0){
			json.put(JSONConstants.COMBOBOX_ITEMS, itemsArry);
//		}
		
		if(meta.getGlobalItems() != null){
			json.put(JSONConstants.COMBOBOX_GLOBALITEMS, meta.getGlobalItems());
		}
		
		if(meta.getQueryDef() != null) {
			MetaParameterCollection parameters = meta.getQueryDef().getParameterCollection();
			String value = null;
			JSONObject jsonObject = null;
			JSONArray jsonArray = new JSONArray();
			if(parameters != null) {
				for (MetaParameter parameter : parameters) {
					jsonObject = new JSONObject();
					switch(parameter.getSourceType()) {
					case ParameterSourceType.CONST:
						value = parameter.getValue();
						break;
					case ParameterSourceType.FORMULA:
						value = parameter.getFormula();
						break;
					case ParameterSourceType.FIELD:
						value = parameter.getFieldKey();
						break;
					}
					jsonObject.put(JSONConstants.COMBOBOX_SOURCETYPE, parameter.getSourceType());
					jsonObject.put(JSONConstants.COMMON_VALUE, value);
					jsonArray.put(jsonObject);
				}
			}
			json.put(JSONConstants.COMBOBOX_QUERYPARAS, jsonArray);
		}
		if(meta.getFormulaItems() != null) {
			json.put(JSONConstants.COMBOBOX_FORMULA, meta.getFormulaItems().getContent().trim());
		}

		// 添加依赖
		builder.addRelations(key, meta.getDependedFields());
	}

}
