package com.bokesoft.yes.mid.web.ui.load.control.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.PropertiesJSONBuilder;
import com.bokesoft.yigo.common.def.ImageScaleType;
import com.bokesoft.yigo.common.def.ImageViewMode;
import com.bokesoft.yigo.common.def.UploadProgressType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaImageProperties;
import com.bokesoft.yigo.tools.ve.VE;

public class ImagePropertiesJSONBuilder  extends PropertiesJSONBuilder<MetaImageProperties> {

	@Override
	protected void loadImpl(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm, MetaImageProperties meta, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_SOURCETYPE, meta.getSourceType(), 0 );
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_IMAGE, meta.getImage() , "" );
//		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_STRETCH, meta.isStretch() , false );
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_MAXSIZE, meta.getMaxSize() , -1 );
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_IMAGECUT, meta.isImageCut() , false );
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_IMAGESCALETYPE, ImageScaleType.toString(meta.getImageScaleType()) , "");
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_PROMPTIMAGE, meta.getPromptImage() , "");
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_RADIUS, meta.getRadius() , -1);
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_FILENAME, meta.getFileName() , "");
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_VIEWMODE,ImageViewMode.toString(meta.getViewMode()), ImageViewMode.STR_SELF);
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_VIEWOPT, meta.isViewOpt() , false );
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_MASKIMAGE, meta.getMaskImage() , "" );
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_SHOWTHUMBNAIL, meta.isShowThumbnail() , true );
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_UPLOADPROGRESS, UploadProgressType.toString(meta.getUploadProgress()) , UploadProgressType.STR_None);
		
		MetaBaseScript onClick = meta.getOnClick();
		if(onClick != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnClick, onClick.getContent(), "");
		}
	}
}
