package com.bokesoft.yes.mid.web.ui.load.control.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.PropertiesJSONBuilder;
import com.bokesoft.yigo.common.def.ImageSourceType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaGIFImageProperties;
import com.bokesoft.yigo.tools.ve.VE;

public class GIFImagePropertiesJSONBuilder extends PropertiesJSONBuilder<MetaGIFImageProperties>{

	@Override
	protected void loadImpl(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaGIFImageProperties meta, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_SOURCETYPE, ImageSourceType.toString(meta.getSourceType()), ImageSourceType.STR_DATA);
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_IMAGE, meta.getImage(), "");
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_IMAGESCALETYPE, meta.getImageScaleType(), -1);
	}
}
