package com.bokesoft.yes.mid.web.ui.load.control;


import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BaseComponentJSONBuilder;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.MetaBPMGraph;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaBPMGraphProperties;
import com.bokesoft.yigo.tools.ve.VE;

public class BPMGraphJSONBuilder extends BaseComponentJSONBuilder<MetaBPMGraph> {

	@Override
	public JSONObject getMetaJSON(VE ve,
			IRootJSONBuilder<AbstractMetaObject> builder, MetaForm metaForm,
			MetaBPMGraph meta) throws Throwable {
		JSONObject metaJSON = super.getMetaJSON(ve, builder, metaForm, meta);
		MetaBPMGraphProperties properties = meta.getProperties();
		JSONHelper.writeToJSON(metaJSON, JSONConstants.BPMGRAPH_PROCESSPATH, properties.getProcessPath(), "");
		JSONHelper.writeToJSON(metaJSON, JSONConstants.BPMGRAPH_PROCESSKEY, properties.getProcessKey(), "");
		JSONHelper.writeToJSON(metaJSON, JSONConstants.BPMGRAPH_PROCESSVER, properties.getProcessVer(), "");
		JSONHelper.writeToJSON(metaJSON, JSONConstants.COMMON_OID, properties.getOID(), "");
		return metaJSON;
	}
	
}
