package com.bokesoft.yes.mid.web.ui.load.anim;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.anim.MetaAnimCollection;
import com.bokesoft.yigo.meta.form.anim.MetaAnimItem;
import com.bokesoft.yigo.tools.ve.VE;

public class AnimCollectionJSONBuilder extends AbstractJSONBuilder<MetaAnimCollection> {

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaAnimCollection meta) throws Throwable {
		if (meta.size() > 0) {
			JSONArray itemArray = new JSONArray();
			for (int i = 0; i < meta.size(); i++) {
				MetaAnimItem metaAnimItem = meta.get(i);
				JSONObject itemObj = builder.build(ve, builder, metaForm, metaAnimItem);
				itemArray.put(itemObj);
			}
			json.put(JSONConstants.COMMON_ANIMCOLLECTION, itemArray);
		}
	}
}
