package com.bokesoft.yes.mid.web.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.bokesoft.yigo.meta.util.MetaUtil;
import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.mid.web.ui.load.FormJSONBuilder;
import com.bokesoft.yes.view.dependency.Relation;
import com.bokesoft.yes.view.dependency.RelationTree;
import com.bokesoft.yes.view.uistruct.FormDependency;
/*import com.bokesoft.yes.view.dependency.Relation;
import com.bokesoft.yes.view.dependency.RelationTree;
import com.bokesoft.yes.view.uistruct.FormDependency;*/
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.common.def.OperationState;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.theme.MetaTheme;
import com.bokesoft.yigo.meta.form.component.view.MetaView;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.meta.strings.MetaStringTable;
import com.bokesoft.yigo.tools.ve.IVEHost;
import com.bokesoft.yigo.tools.ve.VE;
/*import com.bokesoft.yigo.view.UIExprManager;*/
import com.bokesoft.yigo.view.UIExprManager;

public class WebJSONUIBuilderImpl implements IRootJSONBuilder<AbstractMetaObject> {
	/** 表单元数据对象 */
	private MetaForm metaForm = null;
	/** 表单的操作状态 */
	private int operationState = OperationState.Default;
	
	private IVEHost veHost = null;
	
	private MetaView matchView = null;
		
	/**
	 * 通过表单元数据对象初始化界面创建对象
	 * 
	 * @param metaForm 表单元数据
	 */
	public WebJSONUIBuilderImpl(MetaForm metaForm) {
		this.metaForm = metaForm;
	}

	public void setVEHost(IVEHost veHost) {
		this.veHost = veHost;
	}
	
	public IVEHost getVeHost() {
		return veHost;
	}
	
	public MetaForm getMetaForm() {
		return metaForm;
	}
	
	public int getOperationState() {
		return operationState;
	}
	
	/**
	 * 设置表单操作状态
	 * @param operationState 表单操作状态
	 */
	public void setOperationState(int operationState) {
		this.operationState = operationState;
	}

	/**
	 * 创建函数
	 * 
	 * @return 表单json
	 * @throws Exception
	 */
	public JSONObject build() throws Throwable {
		VE ve = veHost.getVE();
		
		//依赖构建
		UIExprManager manager = new UIExprManager(metaForm, ve);
		
		FormJSONBuilder fb = new FormJSONBuilder();
		JSONObject form = fb.build(ve, this, metaForm, metaForm);
		
		//子明细关系
		form.put(JSONConstants.FORM_SUBDETAILINFO, getSubDetails());
		
		//继承表单
		form.put(JSONConstants.FORM_EXTEND, metaForm.getExtend());
		form.put(JSONConstants.COMMON_MERGETOSOURCE, ve.getMetaFactory().getMetaFormList().get(metaForm.getKey()).getMergeToSource());

		// 是否启用变体
		form.put(JSONConstants.FORM_USRVARIANT, metaForm.isUseVariant());
		
		this.dependency = manager.build();
		
		// 动态单元格依赖关系
		List<Relation> relations = manager.buildDynamicCellRelations();
		if( relations != null ) {
			relationTree.addRelations(relations);			
		}
		
		// 依赖对象
		form.put(JSONConstants.FORM_DEPENDENCY, dependency.toJSON());
		
		// 值关系树
		form.put(JSONConstants.FORM_RELATIONS, relationTree.toJSONArray());
				
		//伙伴组件
		form.put(JSONConstants.FORM_BUDDYKEYS, buddyKeys);
					
		return form;
	}
	
	// 子明细
	private Map<String, List<String>> subDetailMap = new HashMap<String, List<String>>();
	
	// 表单依赖树
	private FormDependency dependency = new FormDependency();
	
	// 值关系树,从依赖中分离是因为依赖会重建
	private RelationTree relationTree = new RelationTree();
	
	// 伙伴组件集合
	private JSONArray buddyKeys = new JSONArray();
	
	@Override
	public void addRelation(String target, String field) {
		Relation relation = new Relation(field,target);
		this.relationTree.addRelation(relation);
	}
	
	@Override
	public void addRelations(String target, List<String> fields) {
		if( fields == null || fields.isEmpty() )
			return;
		for( String field : fields ) {
			this.addRelation(target, field);
		}
	}
	
	@Override
	public void addBuddyKey(String buddyKey) {
		this.buddyKeys.put(buddyKey);
	}
	
	@Override
	public void addSubDetail(String key, String controlKey) {
		List<String> list = subDetailMap.get(key);
		if(list == null){
			list = new ArrayList<String>();
		}
		
		list.add(controlKey);
		
		subDetailMap.put(key, list);
	}
	
	private JSONObject getSubDetails() {
		JSONObject json = new JSONObject();
		JSONArray array = null;
		List<String> list = null;
		String key = null;
        for (Map.Entry<String, List<String>> e : subDetailMap.entrySet()) {
        	key = e.getKey();
        	list = e.getValue();
        	if(!list.isEmpty()){
        		array = new JSONArray();
	        	for(String v : list){
	        		array.put(v);
	        	}
        	}
        	json.put(key, array);
        }
		return json;
	}
	
	public JSONObject build(VE ve, 
			IRootJSONBuilder< AbstractMetaObject> builder, MetaForm metaForm, AbstractMetaObject meta) throws Throwable {
		if(meta == null){
			return null;
		}
		
		String controlType = meta.getTagName();
		
		AbstractJSONBuilder<AbstractMetaObject> componentBuilder = UIJSONBuilderMap.getBuilder(controlType);
		JSONObject model = null;
		if (componentBuilder != null) {
			model = componentBuilder.build(ve, this, metaForm, meta);
		}
		return model;
	}
	
	public MetaView getMatchView() {
		return matchView;
	}

	public MetaTheme getMatchTheme() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getString(String group, String groupKey, String word, String org) throws Throwable{
		VE ve = veHost.getVE();
		IMetaFactory metaFactory = ve.getMetaFactory();
		if(!metaFactory.getSolution().isEnableMultiLang()){
			return org;
		}
		
		String s = null;
		String lang = ve.getEnv().getLocale();
		
		String key = group;
		if(groupKey != null && !groupKey.isEmpty()){
			key +="-"+ groupKey;
		}

		switch (GroupKeyTable.parse(group)) {
			case GroupKeyTable.UI:
				s = metaForm.getUILangCaption(lang, key);
				if (s != null) {
					return s;
				}			
				break;
		}

		return MetaUtil.getLocalString(metaFactory, metaForm, lang, key, word, org, s);
	}
}
