package com.bokesoft.yes.mid.web.ui;

import java.util.List;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.theme.MetaTheme;
import com.bokesoft.yigo.meta.form.component.view.MetaView;

public interface IRootJSONBuilder<T extends AbstractMetaObject> extends IJSONBuilder<T> {
	/**
	 * 取得匹配的视图
	 * @return 从视图集合中匹配视图，如果找到则返回，否则返回null
	 */
	public MetaView getMatchView();
	/**
	 * 取得匹配的主题
	 * @return 从主题集合中匹配主题，如果找到则返回，否则返回null
	 */
	public MetaTheme getMatchTheme();
	
	/**
	 * 添加子明细关系
	 * @param key
	 * @param controlKey
	 */
	public void addSubDetail(String key, String controlKey);
	
	/**
	 * 添加伙伴组件标识
	 * @param buddyKey
	 */
	public void addBuddyKey(String buddyKey);
	
	/**
	 * 添加依赖关系
	 * @param target 目标字段
	 * @param field 依赖源字段
	 */
	public void addRelation(String target, String field);
	
	/**
	 * 批量添加依赖关系
	 * @param target 目标字段
	 * @param fields 依赖源字段集合
	 */
	public void addRelations(String target,List<String> fields);
	
	/**
	 * 获取翻译词条
	 * @param group 组
	 * @param key 词条key
	 * @param org 原值
	 * @return
	 * @throws Throwable
	 */
	public String getString(String group, String groupKey, String key, String org) throws Throwable;
}
