package com.bokesoft.yes.mid.web.ui;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.tools.ve.VE;

/**
 * J:当前组件JSON类。
 * T:当前组件配置类。
 */
public abstract class AbstractJSONBuilder<T extends AbstractMetaObject> implements IJSONBuilder<T> {
	
	public JSONObject build(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, MetaForm metaForm, T meta) throws Throwable {
		JSONObject json = newJSON();
		load(ve, builder, json, metaForm, meta);
		return json;
	}
		
	/**
	 * 根据配置信息构造默认的模型对象。
	 */
	public JSONObject newJSON() throws Throwable {
		JSONObject json = new JSONObject();
		return json;
	};
	

	public abstract void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm, T meta) throws Throwable;

}
