//package com.bokesoft.yes.mid.web.cmd;
//
//import java.util.List;
//
//import org.json.JSONObject;
//
//import com.bokesoft.yes.common.struct.StringHashMap;
//import com.bokesoft.yes.datamap.struct.MapResult;
//import com.bokesoft.yes.mid.base.MidVE;
//import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
//import com.bokesoft.yes.mid.cmd.IServiceCmd;
//import com.bokesoft.yes.mid.datamap.MidFormulaProxy;
//import com.bokesoft.yigo.common.def.DataObjectPrimaryType;
//import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
//import com.bokesoft.yigo.meta.factory.IMetaFactory;
//import com.bokesoft.yigo.meta.form.MetaForm;
//import com.bokesoft.yigo.meta.util.MetaUtil;
//import com.bokesoft.yigo.mid.base.DefaultContext;
//import com.bokesoft.yigo.struct.document.Document;
//import com.bokesoft.yigo.tools.document.DocumentUtil;
//
//public class MapCmd extends DefaultServiceCmd {
//
//	private String mapKey = "";
//	private String srcDocObj = "";
//	private String srcFormKey = "";
//	private String tgtFormKey = "";
//	private String tgtDocObj = "";
//	
//	@Override
//	public void dealArguments(DefaultContext context,
//			StringHashMap<Object> arguments) throws Throwable {
//		mapKey = (String) arguments.get("mapKey");
//		srcDocObj = (String) arguments.get("srcDoc");
//		srcFormKey = (String) arguments.get("srcFormKey");
//		tgtFormKey = (String) arguments.get("tgtFormKey");
//		tgtDocObj = (String) arguments.get("tgtDoc");
//	}
//
//	@Override
//	public Object doCmd(DefaultContext context) throws Throwable {
//		MidVE ve = context.getVE();
//		IMetaFactory factory = ve.getMetaFactory();
//		MetaForm metaForm = factory.getMetaForm(tgtFormKey);
//		
//		MetaDataObject tgtDataObject = metaForm.getDataSource().getDataObject();
//		Document doc =  DocumentUtil.newDocument(tgtDataObject);
//		if (tgtDocObj != null && !tgtDocObj.isEmpty()) {
//			JSONObject tgtDocJson = new JSONObject(tgtDocObj);
//			doc.fromJSON(tgtDocJson);
//		} else {
//			doc.setNew();
//			if (tgtDataObject.getPrimaryType() == DataObjectPrimaryType.ENTITY && tgtDataObject.getMainTable() != null) {
//				doc.setOID(context.applyNewOID());
//			}
//		}
//		
//		JSONObject srcDocJson = new JSONObject(srcDocObj);
//		MetaForm srcForm = factory.getMetaForm(srcFormKey);
//		MetaDataObject srcDataObject = srcForm.getDataSource().getDataObject();
//		Document srcDoc =  DocumentUtil.newDocument(srcDataObject);
//		srcDoc.fromJSON(srcDocJson);
//		context.setDocument(srcDoc);
//		
//		WebPureMapProxy webmap = new WebPureMapProxy(srcDoc, mapKey, doc);
//		Document tgtDoc = webmap.mapDoc(context, context.getMidParser(),new MidFormulaProxy(context));
//		
//		List<String> comKeys = MetaUtil.getMapComs(factory, metaForm, mapKey);
//		List<String> gridKeys = MetaUtil.getMapGrids(factory, metaForm, mapKey);
//		
//		MapResult result = new MapResult(tgtDoc, comKeys, gridKeys);
//		
//		return result;
//	}
//
//	@Override
//	public IServiceCmd<DefaultContext> newInstance() {
//		return new MapCmd();
//	}
//
//	@Override
//	public String getCmd() {
//		return "PureMap";
//	}
//
//	@Override
//	public boolean getNeedServiceRight(){
//		return true;
//	}
//}