package com.bokesoft.yes.mid.web.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class GetRelationFormKeyCmd extends DefaultServiceCmd {

	private String formKey = null;
	private String dataObjKey = null;

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		formKey = TypeConvertor.toString(arguments.get("formKey"));
		dataObjKey = TypeConvertor.toString(arguments.get("dataObjKey"));
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaForm metaForm = metaFactory.getMetaForm(this.formKey);
		String ret = metaForm.getFormRelationCollection().getFormKey(dataObjKey);
		return ret;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetRelationFormKeyCmd();
	}

	@Override
	public String getCmd() {
		return "GetRelationFormKey";
	}

	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}
