package com.bokesoft.yes.mid.web.cmd;

import org.json.JSONObject;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.web.util.PrintUtil;
import com.bokesoft.yes.report.MidQueryProxy;
import com.bokesoft.yes.report.ReportDataSource;
import com.bokesoft.yes.report.datasource.IImplReportDataSource;
import com.bokesoft.yes.report.fill.FillPolicy;
import com.bokesoft.yes.report.output.OutputPageSet;
import com.bokesoft.yes.report.proxy.IQueryProxy;
import com.bokesoft.yigo.common.ui.AbstractRuntimeUIConfig;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.common.util.UIUtil;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.report.MetaReport;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.util.DocumentUtil;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.usrpara.Paras;

public class GetOutputPageCmd extends DefaultServiceCmd {
	private Document doc = null;
	private String formKey = null;
	private String reportKey = null;
	private AbstractRuntimeUIConfig runtimeUIConfig;
	
	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		String parameters = TypeConvertor.toString(arguments.get("parameters"));
		if (parameters != null && !parameters.isEmpty()) {
			JSONObject json = new JSONObject(parameters);
			Paras formParameters = new Paras();
			formParameters.fromJSON(json);
			context.setParas(formParameters);
		}
		formKey = TypeConvertor.toString(arguments.get("formKey"));
		
		String str = TypeConvertor.toString(arguments.get("doc"));
		doc = new Document(null, -1);
		JSONObject json = new JSONObject(str);
		doc.fromJSON(json);
		
		reportKey = TypeConvertor.toString(arguments.get("reportKey"));
		String uiconfig = TypeConvertor.toString(arguments.get("uiconfig"));
		if (!StringUtil.isBlankOrNull(uiconfig) && !"{}".equals(uiconfig)) {
			JSONObject jsonUI = new JSONObject(uiconfig);
			runtimeUIConfig = UIUtil.createRuntimeConfig(jsonUI);
		}
	}
	
	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaReport metaReport = metaFactory.getReport("", formKey, reportKey);
		if ( metaReport == null ) {
			throw new MetaException(MetaException.NO_PRINT_TEMPLATE_DEFINED,
					SimpleStringFormat.format(StringTable.getString(context.getEnv(), "", StringTable.NoPrintTemplateDefined), formKey));
		}
		
		OutputPageSet pageSet = new OutputPageSet();
		IQueryProxy queryProxy = new MidQueryProxy(context, formKey);
		doc = PrintUtil.checkTableReload(formKey, doc, context, false);
		IImplReportDataSource dataSource = new ReportDataSource(context.getVE(), queryProxy, doc, context.getParas(), formKey, runtimeUIConfig);
		FillPolicy policy = new FillPolicy(metaReport, dataSource, context.getParas());
		policy.fill(pageSet);
		return pageSet.toJSON();
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetOutputPageCmd();
	}

	@Override
	public String getCmd() {
		return "GetOutputPage";
	}
	
	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}
