package com.bokesoft.yes.mid.web.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class GetFormByTypeCmd extends DefaultServiceCmd {
	private String filter = "";
	
	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		filter = TypeConvertor.toString(arguments.get("filter"));
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		return MetaUtil.getFormByType(context.getVE().getMetaFactory(),filter);
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetFormByTypeCmd();
	}

	@Override
	public String getCmd() {
		return "GetFormByType";
	}
	
}
