/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.certificate;

import com.bokesoft.yigo.mid.base.CertificateException;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.security.PrivateKey;
import java.util.HashMap;

public abstract class AbstractCertificateWarehouse<K> {
    protected static final String KEY_STORE = "JKS";
    protected static final String X509 = "X.509";
    private HashMap<K, String> keyAndAliasMap = new HashMap();

    public boolean check(DefaultContext object, K k2, String string, String string2, String string3) throws Throwable {
        if (!this.contain(k2)) {
            throw new CertificateException(1, "Certificate not found or expired!");
        }
        object = this.getPrivateKey((DefaultContext)object, k2, string);
        return this.doCheck(string2, string3, (PrivateKey)object);
    }

    public void checkFingerprint(DefaultContext object, K k2, String string, String string2, String string3) throws Throwable {
        if (!this.contain(k2)) {
            throw new CertificateException(1, "Certificate not found or expired!");
        }
        String string4 = this.getFingerprint((DefaultContext)object, k2);
        object = this.getPrivateKey((DefaultContext)object, k2, string);
        this.doCheckFingerprint(string4, string2, string3, (PrivateKey)object);
    }

    protected void addKey(K k2, String string) {
        this.keyAndAliasMap.put(k2, string);
    }

    public boolean contain(K k2) {
        return this.keyAndAliasMap.containsKey(k2);
    }

    public String getAlias(K k2) {
        return this.keyAndAliasMap.get(k2);
    }

    protected abstract void initKeyAndAlias(DefaultContext var1) throws Throwable;

    protected abstract PrivateKey getPrivateKey(DefaultContext var1, K var2, String var3) throws Throwable;

    protected abstract String getFingerprint(DefaultContext var1, K var2) throws Throwable;

    protected abstract boolean doCheck(String var1, String var2, PrivateKey var3);

    protected abstract void doCheckFingerprint(String var1, String var2, String var3, PrivateKey var4);

    public abstract Long getOperatorIDByFingerprint(DefaultContext var1, String var2) throws Throwable;
}

