/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.deparseformula;

import com.bokesoft.yes.deparseformula.FormulaUtil;
import com.bokesoft.yes.parser.Item;
import com.bokesoft.yes.parser.SyntaxTree;
import java.util.ArrayList;
import java.util.List;

public class FormulaFormat {
    private final String content;
    private final List<Item> items;
    private final List<Integer> itemIndexes;
    private List<String> formats = new ArrayList<String>();
    private int length;
    private int pos = 0;
    private int start = 0;
    private char c;
    private boolean b_skip = false;
    private boolean c_skip = false;
    private boolean semicolon_skip = false;

    public FormulaFormat(String string, List<Item> list) {
        this.content = string;
        this.items = list;
        this.itemIndexes = new ArrayList<Integer>(list.size());
        this.length = string.length();
    }

    public static FormulaFormat parse(String object, SyntaxTree object2) {
        object2 = FormulaUtil.getLeafItems(((SyntaxTree)object2).getRoot());
        object = new FormulaFormat((String)object, (List<Item>)object2);
        ((FormulaFormat)object).parse();
        return object;
    }

    private void parse() {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        do {
            this.c = this.content.charAt(this.pos);
            ++this.pos;
            do {
                this.c = this.skipBlank(this.c);
                this.c = this.skipComments(this.c);
            } while (this.c_skip || this.b_skip);
            String string = FormulaFormat.getItemLexValue(this.items.get(n4));
            if (string.equals("}") && this.c == ';') {
                do {
                    this.c = this.skipBlank(this.c);
                    this.c = this.skipComments(this.c);
                    this.c = this.skipSemicolon(this.c);
                } while (this.c_skip || this.b_skip || this.semicolon_skip);
            }
            if (string.length() > 0 && this.content.substring(this.pos - 1, this.pos + string.length() - 1).equals(string)) {
                this.formats.add(this.pos > n3 + 1 ? this.content.substring(n3, this.pos - 1) : "");
                this.formats.add(this.content.substring(this.pos - 1, this.pos + string.length() - 1));
                this.pos += string.length() - 1;
            } else if (string.equals("<>") && this.content.substring(this.pos - 1, this.pos + string.length() - 1).equals("!=")) {
                this.formats.add(this.pos > n3 + 1 ? this.content.substring(n3, this.pos - 1) : "");
                this.formats.add(this.content.substring(this.pos - 1, this.pos + string.length() - 1));
                this.pos += string.length() - 1;
            } else if ((string.equalsIgnoreCase("true") || string.equalsIgnoreCase("false")) && this.content.substring(this.pos - 1, this.pos + string.length() - 1).equalsIgnoreCase(string)) {
                this.formats.add(this.pos > n3 + 1 ? this.content.substring(n3, this.pos - 1) : "");
                this.formats.add(this.content.substring(this.pos - 1, this.pos + string.length() - 1));
                this.pos += string.length() - 1;
            } else if (this.content.substring(this.pos, this.pos + string.length()).equals(string)) {
                this.formats.add(this.pos > n3 + 1 ? this.content.substring(n3, this.pos - 1) : "");
                this.formats.add(this.content.substring(this.pos - 1, this.pos + string.length() + 1));
                this.pos += string.length() + 1;
            } else {
                throw new RuntimeException("ERROR!");
            }
            n3 = this.pos;
            this.itemIndexes.add(n2 + 2);
            n2 += 2;
        } while (++n4 != this.items.size());
        this.formats.add(this.pos < this.length ? this.content.substring(this.pos, this.length) : "");
    }

    private static String getItemLexValue(Item item) {
        String string = item.getFullLexValue();
        if (string == null || string.length() == 0) {
            return item.getLexValue();
        }
        return string;
    }

    private char skipBlank(char c2) {
        char c3 = c2;
        this.b_skip = false;
        while (c2 == ' ' || c2 == '\t' || c2 == '\n' || c2 == '\r') {
            this.b_skip = true;
            if (this.pos >= this.length) {
                return c3;
            }
            c2 = this.content.charAt(this.pos);
            c3 = c2;
            ++this.pos;
            ++this.start;
        }
        return c3;
    }

    private char skipSemicolon(char c2) {
        char c3 = c2;
        this.semicolon_skip = false;
        while (c2 == ';') {
            this.semicolon_skip = true;
            if (this.pos >= this.length) {
                return c3;
            }
            c2 = this.content.charAt(this.pos);
            c3 = c2;
            ++this.pos;
            ++this.start;
        }
        return c3;
    }

    private char skipComments(char n2) {
        int n3 = n2;
        this.c_skip = false;
        if (this.pos < this.length) {
            int n4 = this.pos;
            int n5 = this.start++;
            boolean bl = false;
            if (n2 == 47 && this.pos < this.length) {
                n2 = this.content.charAt(this.pos);
                ++this.pos;
                if (n2 == 47) {
                    if (this.pos < this.length) {
                        n2 = this.content.charAt(this.pos);
                        ++this.pos;
                        ++this.start;
                        while (n2 != 10 && this.pos < this.length) {
                            if (this.pos >= this.length) continue;
                            n2 = this.content.charAt(this.pos);
                            ++this.pos;
                            ++this.start;
                        }
                        if (this.pos < this.length) {
                            n2 = this.content.charAt(this.pos);
                            ++this.pos;
                            ++this.start;
                            n3 = n2;
                        } else {
                            n3 = 36;
                        }
                        bl = true;
                    }
                } else if (n2 == 42 && this.pos < this.length) {
                    n2 = this.content.charAt(this.pos);
                    ++this.pos;
                    ++this.start;
                    while (true) {
                        if (n2 == 42 && this.pos < this.length && this.content.charAt(this.pos) == '/') {
                            ++this.pos;
                            ++this.start;
                            bl = true;
                            break;
                        }
                        if (this.pos >= this.length) break;
                        n2 = this.content.charAt(this.pos);
                        ++this.pos;
                        ++this.start;
                    }
                    if (bl) {
                        if (this.pos < this.length) {
                            n2 = this.content.charAt(this.pos);
                            ++this.pos;
                            ++this.start;
                            n3 = n2;
                        } else {
                            n3 = 36;
                        }
                    }
                }
            }
            if (!bl) {
                this.pos = n4;
                this.start = n5;
            } else {
                this.c_skip = true;
            }
        }
        return (char)n3;
    }

    public String getPreFormat(Item item) {
        int n2 = this.items.indexOf(item);
        if (n2 < 0) {
            throw new RuntimeException("ERROR!");
        }
        return this.formats.get(n2 << 1);
    }

    public String getLastFormat() {
        return this.formats.get(this.formats.size() - 1);
    }

    public String getOrgText(Item item) {
        int n2 = this.items.indexOf(item);
        if (n2 < 0) {
            throw new RuntimeException("ERROR!");
        }
        return this.formats.get((n2 << 1) + 1);
    }

    public String toString() {
        return this.formats.toString();
    }
}

