/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.deparseformula;

import com.bokesoft.yes.deparseformula.FormulaFormat;
import com.bokesoft.yes.parser.Item;
import com.bokesoft.yes.parser.Rule;
import com.bokesoft.yes.parser.SyntaxTree;
import org.apache.commons.lang3.NotImplementedException;

public class FormulaDeparserWithFormat {
    public static final FormulaDeparserWithFormat instance = new FormulaDeparserWithFormat();

    public static String deParse(SyntaxTree syntaxTree, String object) {
        object = FormulaFormat.parse((String)object, syntaxTree);
        StringBuilder stringBuilder = new StringBuilder(128);
        return instance.deParse(syntaxTree.getRoot(), stringBuilder, (FormulaFormat)object).append(((FormulaFormat)object).getLastFormat()).toString();
    }

    public static String deParse(Item item, FormulaFormat formulaFormat) {
        StringBuilder stringBuilder = new StringBuilder(128);
        return instance.deParse(item, stringBuilder, formulaFormat).toString();
    }

    public StringBuilder deParse(Item item, StringBuilder stringBuilder, FormulaFormat formulaFormat) {
        Rule rule = item.getRule();
        if (rule != null) {
            switch (rule.getIndex()) {
                case 0: {
                    return this.deParse0Statement(item, stringBuilder, formulaFormat);
                }
                case 1: {
                    return this.deParse1Statements(item, stringBuilder, formulaFormat);
                }
                case 2: {
                    return this.deParse2Addition(item, stringBuilder, formulaFormat);
                }
                case 3: {
                    return this.deparse3Subtraction(item, stringBuilder, formulaFormat);
                }
                case 4: {
                    return this.deParse4Multiplication(item, stringBuilder, formulaFormat);
                }
                case 5: {
                    return this.deParse5Division(item, stringBuilder, formulaFormat);
                }
                case 6: {
                    return this.deParse6Concat(item, stringBuilder, formulaFormat);
                }
                case 7: {
                    return this.deParse7Parenthesis(item, stringBuilder, formulaFormat);
                }
                case 8: {
                    return this.deParse8Not(item, stringBuilder, formulaFormat);
                }
                case 9: {
                    return this.deParse9Or(item, stringBuilder, formulaFormat);
                }
                case 10: {
                    return this.deParse10And(item, stringBuilder, formulaFormat);
                }
                case 11: {
                    return this.deParse11EqualsTo(item, stringBuilder, formulaFormat);
                }
                case 12: {
                    return this.deParse12NotEqualsTo(item, stringBuilder, formulaFormat);
                }
                case 13: {
                    return this.deParse13GreaterThan(item, stringBuilder, formulaFormat);
                }
                case 14: {
                    return this.deParse14GreaterThanEquals(item, stringBuilder, formulaFormat);
                }
                case 15: {
                    return this.deParse15MinorThan(item, stringBuilder, formulaFormat);
                }
                case 16: {
                    return this.deParse16MinorThanEquals(item, stringBuilder, formulaFormat);
                }
                case 17: {
                    return this.deParse17Const(item, stringBuilder, formulaFormat);
                }
                case 18: {
                    return this.deParse18ID(item, stringBuilder, formulaFormat);
                }
                case 19: {
                    return this.deParse19Function(item, stringBuilder, formulaFormat);
                }
                case 20: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 21: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 22: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 23: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 24: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 25: {
                    return this.deParse25Var(item, stringBuilder, formulaFormat);
                }
                case 26: {
                    return this.deParse26IfHead(item, stringBuilder, formulaFormat);
                }
                case 27: {
                    return this.deParse27IfElse(item, stringBuilder, formulaFormat);
                }
                case 28: {
                    return this.deParse26IfHead(item, stringBuilder, formulaFormat);
                }
                case 29: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 30: {
                    return this.deParse30While(item, stringBuilder, formulaFormat);
                }
                case 31: {
                    return this.deParse31SetValue(item, stringBuilder, formulaFormat);
                }
                case 32: {
                    return this.deParse32Return(item, stringBuilder, formulaFormat);
                }
                case 33: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 34: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 35: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 36: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 37: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 38: {
                    throw new NotImplementedException("Code is not implemented");
                }
                case 39: {
                    throw new NotImplementedException("Code is not implemented");
                }
            }
        }
        throw new NotImplementedException("Code is not implemented");
    }

    protected StringBuilder deParse0Statement(Item item, StringBuilder stringBuilder, FormulaFormat formulaFormat) {
        return this.deParse(item.getFactor(0), stringBuilder, formulaFormat);
    }

    protected StringBuilder deParse1Statements(Item item, StringBuilder stringBuilder, FormulaFormat formulaFormat) {
        this.deParse(item.getFactor(0), stringBuilder, formulaFormat);
        int n2 = item.getChildCount();
        for (int i2 = 2; i2 < n2; i2 += 2) {
            Item item2 = item.getFactor(i2 - 1);
            if (item2.getFullLexValue() == null || item2.getFullLexValue().length() == 0) {
                stringBuilder.append(formulaFormat.getPreFormat(item2)).append(";");
            }
            this.deParse(item.getFactor(i2), stringBuilder, formulaFormat);
        }
        return stringBuilder;
    }

    protected StringBuilder deParse2Addition(Item item, StringBuilder stringBuilder, FormulaFormat formulaFormat) {
        this.deParse(item.getFactor(0), stringBuilder, formulaFormat).append(formulaFormat.getPreFormat(item.getFactor(1))).append("+");
        return this.deParse(item.getFactor(2), stringBuilder, formulaFormat);
    }

    protected StringBuilder deparse3Subtraction(Item item, StringBuilder stringBuilder, FormulaFormat formulaFormat) {
        this.deParse(item.getFactor(0), stringBuilder, formulaFormat).append(formulaFormat.getPreFormat(item.getFactor(1))).append("-");
        return this.deParse(item.getFactor(2), stringBuilder, formulaFormat);
    }

    protected StringBuilder deParse4Multiplication(Item item, StringBuilder stringBuilder, FormulaFormat formulaFormat) {
        this.deParse(item.getFactor(0), stringBuilder, formulaFormat).append(formulaFormat.getPreFormat(item.getFactor(1))).append("*");
        return this.deParse(item.getFactor(2), stringBuilder, formulaFormat);
    }

    protected StringBuilder deParse5Division(Item item, StringBuilder stringBuilder, FormulaFormat formulaFormat) {
        this.deParse(item.getFactor(0), stringBuilder, formulaFormat).append(formulaFormat.getPreFormat(item.getFactor(1))).append("/");
        return this.deParse(item.getFactor(2), stringBuilder, formulaFormat);
    }

    protected StringBuilder deParse6Concat(Item item, StringBuilder stringBuilder, FormulaFormat formulaFormat) {
        this.deParse(item.getFactor(0), stringBuilder, formulaFormat).append(formulaFormat.getPreFormat(item.getFactor(1))).append("&");
        return this.deParse(item.getFactor(2), stringBuilder, formulaFormat);
    }

    protected StringBuilder deParse7Parenthesis(Item item, StringBuilder stringBuilder, FormulaFormat formulaFormat) {
        stringBuilder.append(formulaFormat.getPreFormat(item.getFactor(0))).append("(");
        this.deParse(item.getFactor(1), stringBuilder, formulaFormat);
        return stringBuilder.append(formulaFormat.getPreFormat(item.getFactor(2))).append(")");
    }

    protected StringBuilder deParse8Not(Item item, StringBuilder stringBuilder, FormulaFormat formulaFormat) {
        stringBuilder.append(formulaFormat.getPreFormat(item.getFactor(0))).append("!");
        return this.deParse(item.getFactor(1), stringBuilder, formulaFormat);
    }

    protected StringBuilder deParse9Or(Item item, StringBuilder stringBuilder, FormulaFormat formulaFormat) {
        this.deParse(item.getFactor(0), stringBuilder, formulaFormat).append(formulaFormat.getPreFormat(item.getFactor(1))).append("||");
        return this.deParse(item.getFactor(2), stringBuilder, formulaFormat);
    }

    protected StringBuilder deParse10And(Item item, StringBuilder stringBuilder, FormulaFormat formulaFormat) {
        this.deParse(item.getFactor(0), stringBuilder, formulaFormat).append(formulaFormat.getPreFormat(item.getFactor(1))).append("&&");
        return this.deParse(item.getFactor(2), stringBuilder, formulaFormat);
    }

    protected StringBuilder deParse11EqualsTo(Item item, StringBuilder stringBuilder, FormulaFormat formulaFormat) {
        this.deParse(item.getFactor(0), stringBuilder, formulaFormat).append(formulaFormat.getPreFormat(item.getFactor(1))).append("==");
        return this.deParse(item.getFactor(2), stringBuilder, formulaFormat);
    }

    protected StringBuilder deParse12NotEqualsTo(Item item, StringBuilder stringBuilder, FormulaFormat formulaFormat) {
        this.deParse(item.getFactor(0), stringBuilder, formulaFormat).append(formulaFormat.getPreFormat(item.getFactor(1))).append(formulaFormat.getOrgText(item.getFactor(1)));
        return this.deParse(item.getFactor(2), stringBuilder, formulaFormat);
    }

    protected StringBuilder deParse13GreaterThan(Item item, StringBuilder stringBuilder, FormulaFormat formulaFormat) {
        this.deParse(item.getFactor(0), stringBuilder, formulaFormat).append(formulaFormat.getPreFormat(item.getFactor(1))).append(">");
        return this.deParse(item.getFactor(2), stringBuilder, formulaFormat);
    }

    protected StringBuilder deParse14GreaterThanEquals(Item item, StringBuilder stringBuilder, FormulaFormat formulaFormat) {
        this.deParse(item.getFactor(0), stringBuilder, formulaFormat).append(formulaFormat.getPreFormat(item.getFactor(1))).append(">=");
        return this.deParse(item.getFactor(2), stringBuilder, formulaFormat);
    }

    protected StringBuilder deParse15MinorThan(Item item, StringBuilder stringBuilder, FormulaFormat formulaFormat) {
        this.deParse(item.getFactor(0), stringBuilder, formulaFormat).append(formulaFormat.getPreFormat(item.getFactor(1))).append("<");
        return this.deParse(item.getFactor(2), stringBuilder, formulaFormat);
    }

    protected StringBuilder deParse16MinorThanEquals(Item item, StringBuilder stringBuilder, FormulaFormat formulaFormat) {
        this.deParse(item.getFactor(0), stringBuilder, formulaFormat).append(formulaFormat.getPreFormat(item.getFactor(1))).append("<=");
        return this.deParse(item.getFactor(2), stringBuilder, formulaFormat);
    }

    protected StringBuilder deParse17Const(Item item, StringBuilder stringBuilder, FormulaFormat formulaFormat) {
        return stringBuilder.append(formulaFormat.getPreFormat(item.getFactor(0))).append(formulaFormat.getOrgText(item.getFactor(0)));
    }

    protected StringBuilder deParse18ID(Item item, StringBuilder stringBuilder, FormulaFormat formulaFormat) {
        return stringBuilder.append(formulaFormat.getPreFormat(item.getFactor(0))).append(item.getFactor(0).getFullLexValue());
    }

    protected StringBuilder deParse19Function(Item item, StringBuilder stringBuilder, FormulaFormat formulaFormat) {
        stringBuilder.append(formulaFormat.getPreFormat(item.getFactor(0))).append(item.getFactor(0).getFullLexValue()).append(formulaFormat.getPreFormat(item.getFactor(1))).append("(");
        int n2 = item.getChildCount();
        if (n2 >= 4) {
            this.deParse(item.getFactor(2), stringBuilder, formulaFormat);
        }
        for (int i2 = 4; i2 < n2; i2 += 2) {
            stringBuilder.append(formulaFormat.getPreFormat(item.getFactor(i2 - 1))).append(",");
            this.deParse(item.getFactor(i2), stringBuilder, formulaFormat);
        }
        return stringBuilder.append(formulaFormat.getPreFormat(item.getFactor(n2 - 1))).append(")");
    }

    protected StringBuilder deParse25Var(Item item, StringBuilder stringBuilder, FormulaFormat formulaFormat) {
        stringBuilder.append(formulaFormat.getPreFormat(item.getFactor(0))).append(item.getFactor(0).getFullLexValue());
        stringBuilder.append(formulaFormat.getPreFormat(item.getFactor(1))).append(item.getFactor(1).getFullLexValue()).append(formulaFormat.getPreFormat(item.getFactor(2))).append("=");
        return this.deParse(item.getFactor(3), stringBuilder, formulaFormat);
    }

    protected StringBuilder deParse26IfHead(Item item, StringBuilder stringBuilder, FormulaFormat formulaFormat) {
        stringBuilder.append(formulaFormat.getPreFormat(item.getFactor(0))).append(item.getFactor(0).getFullLexValue()).append(formulaFormat.getPreFormat(item.getFactor(1))).append("(");
        this.deParse(item.getFactor(2), stringBuilder, formulaFormat).append(formulaFormat.getPreFormat(item.getFactor(3))).append(")").append(formulaFormat.getPreFormat(item.getFactor(4))).append("{");
        return this.deParse(item.getFactor(5), stringBuilder, formulaFormat).append(formulaFormat.getPreFormat(item.getFactor(6))).append("}");
    }

    protected StringBuilder deParse27IfElse(Item item, StringBuilder stringBuilder, FormulaFormat formulaFormat) {
        stringBuilder.append(formulaFormat.getPreFormat(item.getFactor(0))).append(item.getFactor(0).getFullLexValue()).append(formulaFormat.getPreFormat(item.getFactor(1))).append("(");
        this.deParse(item.getFactor(2), stringBuilder, formulaFormat).append(formulaFormat.getPreFormat(item.getFactor(3))).append(")").append(formulaFormat.getPreFormat(item.getFactor(4))).append("{");
        this.deParse(item.getFactor(5), stringBuilder, formulaFormat).append(formulaFormat.getPreFormat(item.getFactor(6))).append("}");
        stringBuilder.append(formulaFormat.getPreFormat(item.getFactor(7))).append(item.getFactor(7).getFullLexValue()).append(formulaFormat.getPreFormat(item.getFactor(8))).append("{");
        return this.deParse(item.getFactor(9), stringBuilder, formulaFormat).append(formulaFormat.getPreFormat(item.getFactor(10))).append("}");
    }

    protected StringBuilder deParse30While(Item item, StringBuilder stringBuilder, FormulaFormat formulaFormat) {
        stringBuilder.append(formulaFormat.getPreFormat(item.getFactor(0))).append(item.getFactor(0).getFullLexValue()).append(formulaFormat.getPreFormat(item.getFactor(1))).append("(");
        this.deParse(item.getFactor(2), stringBuilder, formulaFormat).append(formulaFormat.getPreFormat(item.getFactor(3))).append(")").append(formulaFormat.getPreFormat(item.getFactor(4))).append("{");
        return this.deParse(item.getFactor(5), stringBuilder, formulaFormat).append(formulaFormat.getPreFormat(item.getFactor(6))).append("}");
    }

    protected StringBuilder deParse31SetValue(Item item, StringBuilder stringBuilder, FormulaFormat formulaFormat) {
        Item item2 = item.getFactor(0).getFactor(0);
        stringBuilder.append(formulaFormat.getPreFormat(item2)).append(item2.getFullLexValue()).append(formulaFormat.getPreFormat(item.getFactor(1))).append("=");
        return this.deParse(item.getFactor(2), stringBuilder, formulaFormat);
    }

    protected StringBuilder deParse32Return(Item item, StringBuilder stringBuilder, FormulaFormat formulaFormat) {
        stringBuilder.append(formulaFormat.getPreFormat(item.getFactor(0))).append(item.getFactor(0).getFullLexValue());
        return this.deParse(item.getFactor(1), stringBuilder, formulaFormat);
    }
}

