package com.bokesoft.yigo.parser;



/**
 * BaseFunImplCluster是所有函数簇的基类，避免外部重写编写同样实现代码。其主要作用是用来外部扩展函数名称和函数实现的配对。
 * 派生类只需要实现getImplTable函数返回一个Object[][]的数组，数组中的每一行中最后一个为函数的实现，之前的为函数名称，例如。
 * <blockquote><pre>
 * class MyFunction extends BaseFunImplCluster {
 *     public MyFunction() {
 *         super();
 *     }
 *     
 *     public Object[][] getImplTable() {
 *         return new Object[][] {
 *             { "set1", "set2", new SetImpl() },
 *             { "get", new GetImpl() }
 *         }
 *     }
 * }
 * </pre></blockquote>
 * @author 王元和
 * @since YES1.0
 */
public abstract class BaseFunImplCluster implements IFunImplCluster {
	public BaseFunImplCluster() {
	}
	
	@Override
	public abstract Object[][] getImplTable();
}
