/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.parser;

import java.util.TreeMap;

public class Lexer {
    private String content = null;
    private String lexID = null;
    private String lexValue = null;
    private String fullLexValue = null;
    private int type = -1;
    private int start = -1;
    private int pos = 0;
    private boolean b_skip = false;
    private boolean c_skip = false;
    private String obj = null;
    private int err = -1;
    private int length = 0;
    private TreeMap<String, Integer> keyWordMap = null;
    private int lastID = -1;

    public Lexer() {
        this.init();
    }

    public Lexer(String string) {
        this.content = string;
        this.length = string.length();
        this.init();
    }

    public void setContent(String string) {
        this.content = string;
        this.length = string.length();
        this.pos = 0;
    }

    private int lookSemi() {
        int n2 = 26;
        int n3 = this.pos;
        if (this.pos < this.length) {
            char c2 = this.content.charAt(this.pos);
            ++this.pos;
            do {
                c2 = this.skipBlank(c2);
                if (this.err == -1) {
                    return -1;
                }
                c2 = this.skipComments(c2);
                c2 = this.skipBlank(c2);
                if (this.err != -1) continue;
                return -1;
            } while (this.c_skip || this.b_skip);
            if (c2 == '}') {
                this.lexID = "}";
                this.lexValue = "}";
                return 28;
            }
            this.pos = n3;
        } else {
            n2 = -1;
        }
        return n2;
    }

    private boolean lookahead(char c2) {
        int n2 = this.pos;
        if (this.pos < this.length) {
            char c3 = this.content.charAt(this.pos);
            ++this.pos;
            do {
                c3 = this.skipBlank(c3);
                if (this.err == -1) {
                    return false;
                }
                c3 = this.skipComments(c3);
                c3 = this.skipBlank(c3);
                if (this.err != -1) continue;
                return false;
            } while (this.c_skip || this.b_skip);
            if (c3 == c2) {
                this.pos = n2;
                return true;
            }
            this.pos = n2;
        }
        this.pos = n2;
        return false;
    }

    private char skipComments(char n2) {
        int n3 = n2;
        this.c_skip = false;
        if (this.pos < this.length) {
            int n4 = this.pos;
            int n5 = this.start++;
            boolean bl = false;
            if (n2 == 47 && this.pos < this.length) {
                n2 = this.content.charAt(this.pos);
                ++this.pos;
                if (n2 == 47) {
                    if (this.pos < this.length) {
                        n2 = this.content.charAt(this.pos);
                        ++this.pos;
                        ++this.start;
                        while (n2 != 10 && this.pos < this.length) {
                            if (this.pos >= this.length) continue;
                            n2 = this.content.charAt(this.pos);
                            ++this.pos;
                            ++this.start;
                        }
                        if (this.pos < this.length) {
                            n2 = this.content.charAt(this.pos);
                            ++this.pos;
                            ++this.start;
                            n3 = n2;
                        } else {
                            n3 = 36;
                        }
                        bl = true;
                    }
                } else if (n2 == 42 && this.pos < this.length) {
                    n2 = this.content.charAt(this.pos);
                    ++this.pos;
                    ++this.start;
                    while (true) {
                        if (n2 == 42 && this.pos < this.length && this.content.charAt(this.pos) == '/') {
                            ++this.pos;
                            ++this.start;
                            bl = true;
                            break;
                        }
                        if (this.pos >= this.length) break;
                        n2 = this.content.charAt(this.pos);
                        ++this.pos;
                        ++this.start;
                    }
                    if (bl) {
                        if (this.pos < this.length) {
                            n2 = this.content.charAt(this.pos);
                            ++this.pos;
                            ++this.start;
                            n3 = n2;
                        } else {
                            n3 = 36;
                        }
                    }
                }
            }
            if (!bl) {
                this.pos = n4;
                this.start = n5;
            } else {
                this.c_skip = true;
            }
        }
        return (char)n3;
    }

    private char skipBlank(char c2) {
        char c3 = c2;
        this.err = 0;
        this.b_skip = false;
        while (c2 == ' ' || c2 == '\t' || c2 == '\n' || c2 == '\r') {
            this.b_skip = true;
            if (this.pos >= this.length) {
                this.err = -1;
                return c3;
            }
            c2 = this.content.charAt(this.pos);
            c3 = c2;
            ++this.pos;
            ++this.start;
        }
        return c3;
    }

    private boolean checkNegtive() {
        return this.lastID == -1 || this.lastID >= 0 && this.lastID <= 13 || this.lastID == 17 || this.lastID == 19;
    }

    public int next() {
        return this.next(false);
    }

    public int next(boolean n2) {
        this.err = 0;
        this.obj = null;
        this.fullLexValue = null;
        int n3 = this.pos;
        int n4 = -1;
        this.start = this.pos;
        if (this.pos >= this.length) {
            return -1;
        }
        char c2 = this.content.charAt(this.pos);
        ++this.pos;
        do {
            c2 = this.skipBlank(c2);
            if (this.err == -1) {
                return -1;
            }
            c2 = this.skipComments(c2);
            c2 = this.skipBlank(c2);
            if (this.err != -1) continue;
            return -1;
        } while (this.c_skip || this.b_skip);
        int n5 = 1;
        switch (c2) {
            case '+': {
                n4 = 0;
                this.lexID = "+";
                this.lexValue = "+";
                break;
            }
            case '-': {
                if (this.checkNegtive()) {
                    n2 = 32;
                    if (this.pos < this.length) {
                        n2 = this.content.charAt(this.pos);
                    }
                    if (Character.isDigit((char)n2)) {
                        n2 = 1;
                        if (this.pos < this.length) {
                            c2 = this.content.charAt(this.pos);
                        }
                        while (Character.isDigit(c2) || c2 == '.') {
                            if (c2 == '.') {
                                n2 = 0;
                            }
                            ++n5;
                            ++this.pos;
                            if (this.pos >= this.length) break;
                            c2 = this.content.charAt(this.pos);
                        }
                        n4 = 16;
                        this.type = n2 != 0 ? 0 : 1;
                        this.lexID = "const";
                        this.lexValue = this.content.substring(this.start, this.start + n5);
                        break;
                    }
                    n4 = 2;
                    this.lexID = "-";
                    this.lexValue = "-";
                    break;
                }
                n4 = 2;
                this.lexID = "-";
                this.lexValue = "-";
                break;
            }
            case '*': {
                n4 = 3;
                this.lexID = "*";
                this.lexValue = "*";
                break;
            }
            case '/': {
                n4 = 4;
                this.lexID = "/";
                this.lexValue = "/";
                break;
            }
            case '(': {
                n4 = 17;
                this.lexID = "(";
                this.lexValue = "(";
                break;
            }
            case '{': {
                if (n2) {
                    n2 = 1;
                    do {
                        if (this.pos < this.length) {
                            c2 = this.content.charAt(this.pos);
                            if (c2 == '{') {
                                n2 += 1;
                            } else if (c2 == '}') {
                                n2 -= 1;
                            }
                            ++this.pos;
                            ++n5;
                            continue;
                        }
                        this.err = 1;
                        return -1;
                    } while (c2 != '}' || n2);
                    n4 = 16;
                    this.type = 2;
                    this.lexID = "const";
                    this.lexValue = this.content.substring(this.start + 1, this.start + n5 - 1);
                    break;
                }
                n4 = 27;
                this.lexID = "{";
                this.lexValue = "{";
                break;
            }
            case ')': {
                n4 = 18;
                this.lexID = ")";
                this.lexValue = ")";
                break;
            }
            case '}': {
                n4 = 28;
                this.lexID = "}";
                this.lexValue = "}";
                break;
            }
            case ',': {
                n4 = 19;
                this.lexID = ",";
                this.lexValue = ",";
                break;
            }
            case ';': {
                this.lexID = ";";
                this.lexValue = ";";
                n4 = this.lookSemi();
                break;
            }
            case '!': {
                if (this.pos < this.length) {
                    if (this.content.charAt(this.pos) == '=') {
                        n4 = 9;
                        this.lexID = "<>";
                        this.lexValue = "<>";
                        ++this.pos;
                        break;
                    }
                    n4 = 25;
                    this.lexID = "!";
                    this.lexValue = "!";
                    break;
                }
                n4 = 25;
                this.lexID = "!";
                this.lexValue = "!";
                break;
            }
            case '=': {
                if (this.pos < this.length) {
                    if (this.content.charAt(this.pos) == '=') {
                        n4 = 7;
                        this.lexID = "==";
                        this.lexValue = "==";
                        ++this.pos;
                        break;
                    }
                    n4 = 8;
                    this.lexID = "=";
                    this.lexValue = "=";
                    break;
                }
                n4 = 8;
                this.lexID = "=";
                this.lexValue = "=";
                break;
            }
            case '&': {
                if (this.pos < this.length) {
                    if (this.content.charAt(this.pos) == '&') {
                        n4 = 6;
                        this.lexID = "&&";
                        this.lexValue = "&&";
                        ++this.pos;
                        break;
                    }
                    n4 = 1;
                    this.lexID = "&";
                    this.lexValue = "&";
                    break;
                }
                n4 = 1;
                this.lexID = "&";
                this.lexValue = "&";
                break;
            }
            case '|': {
                n4 = -1;
                if (this.pos >= this.length || this.content.charAt(this.pos) != '|') break;
                n4 = 5;
                this.lexID = "||";
                this.lexValue = "||";
                ++this.pos;
                break;
            }
            case '>': {
                if (this.pos < this.length) {
                    if (this.content.charAt(this.pos) == '=') {
                        n4 = 11;
                        this.lexID = ">=";
                        this.lexValue = ">=";
                        ++this.pos;
                        break;
                    }
                    n4 = 10;
                    this.lexID = ">";
                    this.lexValue = ">";
                    break;
                }
                n4 = 10;
                this.lexID = ">";
                this.lexValue = ">";
                break;
            }
            case '<': {
                if (this.pos < this.length) {
                    c2 = this.content.charAt(this.pos);
                    if (c2 == '=') {
                        n4 = 13;
                        this.lexID = "<=";
                        this.lexValue = "<=";
                        ++this.pos;
                        break;
                    }
                    if (c2 == '>') {
                        n4 = 9;
                        this.lexID = "<>";
                        this.lexValue = "<>";
                        ++this.pos;
                        break;
                    }
                    n4 = 12;
                    this.lexID = "<";
                    this.lexValue = "<";
                    break;
                }
                n4 = 12;
                this.lexID = "<";
                this.lexValue = "<";
                break;
            }
            case '\'': {
                do {
                    if (this.pos < this.length) {
                        c2 = this.content.charAt(this.pos);
                        ++this.pos;
                        ++n5;
                        continue;
                    }
                    this.err = 1;
                    return -1;
                } while (c2 != '\'');
                n4 = 16;
                this.lexID = "const";
                this.type = 2;
                this.lexValue = this.content.substring(this.start + 1, this.start + n5 - 1);
                break;
            }
            case '\"': {
                do {
                    if (this.pos < this.length) {
                        c2 = this.content.charAt(this.pos);
                        ++this.pos;
                        ++n5;
                        continue;
                    }
                    this.err = 1;
                    return -1;
                } while (c2 != '\"');
                n4 = 16;
                this.type = 2;
                this.lexID = "const";
                this.lexValue = this.content.substring(this.start + 1, this.start + n5 - 1);
                break;
            }
            case '[': {
                do {
                    if (this.pos < this.length) {
                        c2 = this.content.charAt(this.pos);
                        ++this.pos;
                        ++n5;
                        continue;
                    }
                    this.err = 1;
                    return -1;
                } while (c2 != ']');
                n4 = 15;
                this.lexID = "id";
                this.lexValue = this.content.substring(this.start + 1, this.start + n5 - 1);
                break;
            }
            case ':': {
                n4 = 35;
                this.lexID = ":";
                this.lexValue = ":";
                break;
            }
            default: {
                if (Character.isDigit(c2)) {
                    n2 = 1;
                    if (this.pos < this.length) {
                        c2 = this.content.charAt(this.pos);
                        while (Character.isDigit(c2) || c2 == '.') {
                            if (c2 == '.') {
                                n2 = 0;
                            }
                            ++n5;
                            ++this.pos;
                            if (this.pos >= this.length) break;
                            c2 = this.content.charAt(this.pos);
                        }
                    }
                    n4 = 16;
                    this.type = n2 != 0 ? 0 : 1;
                    this.lexID = "const";
                    this.lexValue = this.content.substring(this.start, this.start + n5);
                    break;
                }
                if (!Character.isLetter(c2) && c2 != '_' && c2 <= '\u007f') break;
                n2 = 0;
                if (this.pos < this.length) {
                    c2 = this.content.charAt(this.pos);
                    while (Character.isLetterOrDigit(c2) || c2 == '.' || c2 == '_' || c2 == ':' || c2 > '\u007f') {
                        if (c2 == ':') {
                            n2 = 1;
                        }
                        ++n5;
                        ++this.pos;
                        if (this.pos >= this.length) break;
                        c2 = this.content.charAt(this.pos);
                    }
                }
                if (n2) {
                    n4 = 32;
                    this.lexID = "range";
                    this.lexValue = this.content.substring(this.start, this.start + n5);
                    break;
                }
                n4 = 15;
                this.lexID = "id";
                this.lexValue = this.content.substring(this.start, this.start + n5);
                Lexer lexer = this;
                n2 = lexer.resolveConst(lexer.lexValue);
                if (n2 != -1) {
                    n4 = n2;
                    this.lexID = "const";
                    break;
                }
                Lexer lexer2 = this;
                n2 = lexer2.resolveID(lexer2.lexValue);
                if (n2 != -1) {
                    n4 = n2;
                    this.lexID = this.lexValue;
                    break;
                }
                if (!this.lookahead('(')) break;
                n4 = 14;
                this.lexID = "fun";
            }
        }
        if (this.lastID == 28 && n4 != -1 && n4 != 26 && n4 != 22 && n4 != 28) {
            n4 = 26;
            this.lexID = ";";
            this.lexValue = ";";
            this.pos = n3;
        }
        this.lastID = n4;
        return n4;
    }

    public String getLexID() {
        return this.lexID;
    }

    public String getLexValue() {
        return this.lexValue;
    }

    public String getFullLexValue() {
        return this.fullLexValue;
    }

    public int getType() {
        return this.type;
    }

    public int getErrorID() {
        return this.err;
    }

    public String getObject() {
        return this.obj;
    }

    protected void init() {
        this.keyWordMap = new TreeMap();
        this.keyWordMap.put("if", 21);
        this.keyWordMap.put("\u5982\u679c", 21);
        this.keyWordMap.put("else", 22);
        this.keyWordMap.put("\u5426\u5219", 22);
        this.keyWordMap.put("while", 23);
        this.keyWordMap.put("\u5f53", 23);
        this.keyWordMap.put("var", 24);
        this.keyWordMap.put("\u5b9a\u4e49", 24);
        this.keyWordMap.put("return", 29);
        this.keyWordMap.put("\u8fd4\u56de", 29);
        this.keyWordMap.put("break", 30);
        this.keyWordMap.put("\u4e2d\u65ad", 30);
        this.keyWordMap.put("switch", 33);
        this.keyWordMap.put("case", 34);
    }

    protected int resolveID(String string) {
        Object object;
        int n2 = string.lastIndexOf(46);
        if (n2 > 0) {
            object = string.substring(0, n2);
            String string2 = string.substring(n2 + 1);
            this.fullLexValue = string;
            string = string2;
            this.obj = object;
            this.lexValue = string2;
        } else {
            this.obj = null;
            this.lexValue = string;
            this.fullLexValue = string;
        }
        object = this.keyWordMap.get(string);
        if (object != null) {
            return (Integer)object;
        }
        if ("loop".equals(string)) {
            return 31;
        }
        return -1;
    }

    protected int resolveConst(String string) {
        if (string.equalsIgnoreCase("true")) {
            this.lexValue = "true";
            this.type = 3;
            return 16;
        }
        if (string.equalsIgnoreCase("false")) {
            this.lexValue = "false";
            this.type = 3;
            return 16;
        }
        return -1;
    }
}

