/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.resultset;

import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;

public class SimpleDocumentDBUtil {
    public static DataTable populate(ResultSet resultSet) throws SQLException {
        return SimpleDocumentDBUtil.impl_populate(resultSet);
    }

    public static DataTable populate(ResultSetMetaData resultSetMetaData) throws SQLException {
        return SimpleDocumentDBUtil.impl_populate(resultSetMetaData);
    }

    private static DataTable impl_populate(ResultSetMetaData resultSetMetaData) throws SQLException {
        DataTable dataTable = new DataTable();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i2 = 1; i2 <= resultSetMetaData.getColumnCount(); ++i2) {
            int n2 = resultSetMetaData.getColumnType(i2);
            String string = resultSetMetaData.getColumnLabel(i2);
            if (string == null || string.isEmpty()) {
                throw new MidCoreException(25, MidCoreException.formatMessage(null, (int)25, (Object[])new Object[0]));
            }
            int n3 = SimpleDocumentDBUtil.convertDataType(resultSetMetaData.getColumnType(i2));
            arrayList.add(n2);
            arrayList2.add(n3);
            ColumnInfo columnInfo = new ColumnInfo(resultSetMetaData.getColumnLabel(i2), n3);
            dataTable.addColumn(columnInfo);
        }
        return dataTable;
    }

    private static DataTable impl_populate(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        DataTable dataTable = SimpleDocumentDBUtil.impl_populate(resultSetMetaData);
        resultSet.beforeFirst();
        if (resultSet.next()) {
            do {
                dataTable.append();
                for (int i2 = 1; i2 <= resultSetMetaData.getColumnCount(); ++i2) {
                    Object object = resultSet.getObject(i2);
                    dataTable.setObject(i2 - 1, object);
                }
            } while (resultSet.next());
        }
        resultSet.close();
        return dataTable;
    }

    public static int convertDataType(int n2) {
        switch (n2) {
            case -5: {
                return 1010;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return 1008;
            }
            case 2005: 
            case 2011: {
                return 1011;
            }
            case -15: 
            case 1: 
            case 12: {
                return 1012;
            }
            case -16: 
            case -9: 
            case -1: {
                return 1002;
            }
            case 91: {
                return 1003;
            }
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                return 1004;
            }
            case 2: 
            case 3: {
                return 1005;
            }
            case 8: {
                return 1006;
            }
            case 6: {
                return 1007;
            }
            case -6: 
            case 4: 
            case 5: {
                return 1001;
            }
        }
        return -1;
    }

    public static int convertJDBCDataType(int n2) {
        switch (n2) {
            case 1010: {
                return -5;
            }
            case 1008: {
                return -2;
            }
            case 1011: {
                return 2005;
            }
            case 1012: {
                return 12;
            }
            case 1002: {
                return -9;
            }
            case 1003: {
                return 91;
            }
            case 1004: {
                return 92;
            }
            case 1005: {
                return 3;
            }
            case 1006: {
                return 8;
            }
            case 1007: {
                return 6;
            }
            case 1001: {
                return 4;
            }
        }
        return -1;
    }
}

