package com.bokesoft.yes.mid.function;

import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.parser.BaseMidFunctionImpl;
import com.bokesoft.yigo.parser.BaseFunImplCluster;
import com.bokesoft.yigo.parser.IExecutor;

public class MidHeadInfoFunction extends BaseFunImplCluster {

	/**
	 * 获取headInfo值
	 * <ul>
	 * <li>key 标识
	 * </ul>
	 */
	class GetHeadInfoImpl extends BaseMidFunctionImpl {

		@Override
		public Object evalImpl(String name, DefaultContext context, Object[] args, IExecutor executor)
				throws Throwable {
			// 获取值
			String key = TypeConvertor.toString(args[0]);

			return context.getHeadInfo(key);
		}

	}

	@Override
	public Object[][] getImplTable() {
		return new Object[][] { { "GetHeadInfo", new GetHeadInfoImpl() } };
	}

}
