/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.form.component.control.properties;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaListBoxItemCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaQueryDef;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class MetaSegmentedControlProperties
extends AbstractMetaObject {
    private Boolean isEditable = false;
    private Boolean isDynamicItems = false;
    private MetaBaseScript formulaItems = null;
    private MetaListBoxItemCollection items = null;
    private String itemsDependency = "";
    private List<String> dependentFields = new ArrayList<String>();
    private MetaQueryDef query = null;
    private Integer sourceType = 0;
    private String groupKey = "";
    private String globalItems = "";
    private Boolean integerValue = false;

    public MetaSegmentedControlProperties() {
        this.items = new MetaListBoxItemCollection();
    }

    public void setEditable(Boolean isEditable) {
        this.isEditable = isEditable;
    }

    public Boolean isEditable() {
        return this.isEditable;
    }

    public String getGlobalItems() {
        return this.globalItems;
    }

    public void setGlobalItems(String globalItems) {
        this.globalItems = globalItems;
    }

    public void setDynamicItems(Boolean isDynamicItems) {
        this.isDynamicItems = isDynamicItems;
    }

    public Boolean isDynamicItems() {
        return this.isDynamicItems;
    }

    public void setFormulaItems(MetaBaseScript formulaItems) {
        this.formulaItems = formulaItems;
    }

    public MetaBaseScript getFormulaItems() {
        return this.formulaItems;
    }

    public List<String> getDependedFields() {
        return this.dependentFields;
    }

    public String getItemsDependency() {
        return this.itemsDependency;
    }

    public void setItemsDependency(String dependency) {
        this.itemsDependency = "";
        this.dependentFields.clear();
        if (dependency != null && dependency.length() > 0) {
            String[] fields;
            this.itemsDependency = dependency;
            for (String field : fields = this.itemsDependency.split(",")) {
                this.dependentFields.add(field);
            }
        }
    }

    public void setDependentFields(List<String> dependentFields) {
        this.dependentFields = dependentFields;
    }

    public Boolean isIntegerValue() {
        return this.integerValue;
    }

    public void setIntegerValue(Boolean integerValue) {
        this.integerValue = integerValue;
    }

    public int getItemCount() {
        return this.items.size();
    }

    public MetaDefaultItem getItem(int index) {
        return (MetaDefaultItem)this.items.get(index);
    }

    public void setItems(MetaListBoxItemCollection items) {
        this.items = items;
    }

    public MetaListBoxItemCollection getItems() {
        return this.items;
    }

    public void setQueryDef(MetaQueryDef query) {
        this.query = query;
    }

    public MetaQueryDef getQueryDef() {
        return this.query;
    }

    public Integer getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(Integer type) {
        this.sourceType = type;
    }

    public String getGroupKey() {
        return this.groupKey;
    }

    public void setGroupKey(String groupKey) {
        this.groupKey = groupKey;
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        this.addAll(list, new AbstractMetaObject[]{this.items, this.formulaItems, this.query});
    }

    @Override
    public String getTagName() {
        return null;
    }

    @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
        super.doPostProcess(flag, callback);
        if (this.query != null) {
            this.query.doPostProcess(flag, callback);
            List<String> list = this.query.getDependedFields();
            if (list != null) {
                for (String field : list) {
                    if (this.dependentFields.contains(field)) continue;
                    this.dependentFields.add(field);
                }
            }
        }
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        AbstractMetaObject resultMetaObject = this.items.createChildMetaObject(env, doc, node, tagName, flag, runType);
        if (resultMetaObject == null) {
            if (tagName.equalsIgnoreCase("FormulaItems")) {
                this.formulaItems = new MetaBaseScript("FormulaItems");
                resultMetaObject = this.formulaItems;
            } else if (tagName.equalsIgnoreCase("QueryDef")) {
                this.query = new MetaQueryDef();
                resultMetaObject = this.query;
            }
        }
        return resultMetaObject;
    }

    @Override
    public AbstractMetaObject clone() {
        MetaSegmentedControlProperties newObject = new MetaSegmentedControlProperties();
        newObject.setEditable(this.isEditable);
        newObject.setItems(this.items == null ? null : (MetaListBoxItemCollection)this.items.clone());
        newObject.setDynamicItems(this.isDynamicItems);
        newObject.setFormulaItems(this.formulaItems == null ? null : (MetaBaseScript)this.formulaItems.clone());
        newObject.setItemsDependency(this.itemsDependency);
        newObject.setQueryDef(this.query == null ? null : (MetaQueryDef)this.query.clone());
        newObject.setSourceType(this.sourceType);
        newObject.setGroupKey(this.groupKey);
        newObject.setGlobalItems(this.globalItems);
        newObject.setIntegerValue(this.integerValue);
        newObject.setDependentFields(this.dependentFields);
        return newObject;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaSegmentedControlProperties();
    }
}

