/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.flatcanvas.node;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.flatcanvas.common.AttributeItem;
import com.bokesoft.yigo.meta.flatcanvas.convertor.IContentHandler;
import com.bokesoft.yigo.meta.flatcanvas.convertor.INode;
import com.bokesoft.yigo.meta.flatcanvas.node.AbstractMetaFCObject;
import com.bokesoft.yigo.meta.flatcanvas.node.MetaFCDataBind;
import com.bokesoft.yigo.meta.flatcanvas.node.MetaFCGraph;
import com.bokesoft.yigo.meta.flatcanvas.node.MetaFCSectionCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Observer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetaFCSection
extends AbstractMetaFCObject {
    public static final String TAG_NAME = "Section";
    public static final List<String> ATTRS_SECTION = Arrays.asList("id", "key", "caption", "visible");
    private MetaFCDataBind dataBindModel = new MetaFCDataBind();
    private MetaFCGraph graphModel = new MetaFCGraph();
    private MetaFCSectionCollection sectionCollection = new MetaFCSectionCollection();
    private MetaFCSection parent = null;

    public MetaFCSection() {
    }

    public MetaFCSection(String type) {
        this.setType(type);
    }

    public void setId(String id) {
        this.set("id", id);
    }

    public String getId() {
        return this.get("id");
    }

    @Override
    public void setKey(String key) {
        this.set("key", key);
    }

    @Override
    public String getKey() {
        return this.get("key");
    }

    @Override
    public void setCaption(String caption) {
        this.set("caption", caption);
    }

    @Override
    public String getCaption() {
        return this.get("caption");
    }

    public void setStroke(int red, int green, int blue) {
        this.graphModel.setStroke(red, green, blue);
    }

    public void setFillColor(int red, int green, int blue) {
        this.graphModel.setFill(red, green, blue);
    }

    public void setType(String type) {
        this.graphModel.set("type", type);
    }

    public String getType() {
        return TypeConvertor.toString((Object)this.graphModel.get("type"));
    }

    public String getVisible() {
        return TypeConvertor.toString((Object)this.get("visible"));
    }

    public void addSection(MetaFCSection metaSection) {
        this.sectionCollection.addItem(metaSection);
    }

    public void removeSection(MetaFCSection section) {
        this.sectionCollection.remove(section);
    }

    public void setParent(MetaFCSection parent) {
        this.parent = parent;
    }

    public MetaFCSection getParent() {
        return this.parent;
    }

    public MetaFCGraph getGraph() {
        return this.graphModel;
    }

    public MetaFCDataBind getDataBind() {
        return this.dataBindModel;
    }

    public MetaFCSection getSection(String key) {
        return this.sectionCollection.getSection(key);
    }

    public MetaFCSection getSection(int index) {
        return (MetaFCSection)this.sectionCollection.get(index);
    }

    public Collection<MetaFCSection> sections() {
        return this.sectionCollection.values();
    }

    public String getCurTableKey() {
        return this.dataBindModel.getCurTableKey();
    }

    public String getTableKey() {
        for (MetaFCSection tmp = this; tmp != null; tmp = tmp.getParent()) {
            String curTableKey = tmp.getCurTableKey();
            if (StringUtil.isBlankOrNull((String)curTableKey)) continue;
            return tmp.getCurTableKey();
        }
        return null;
    }

    public boolean isSectionInTable() {
        String tableKey = this.getCurTableKey();
        return StringUtil.isBlankOrNull((String)tableKey) && !StringUtil.isBlankOrNull((String)this.getTableKey());
    }

    @Override
    public List<String> getPropItemKeys() {
        return ATTRS_SECTION;
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    protected void loadChild(Element elem) {
        NodeList childNodes = elem.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            if ("Graph".equalsIgnoreCase(element.getTagName())) {
                this.graphModel.loadFromElement(element);
                continue;
            }
            if ("DataBind".equalsIgnoreCase(element.getTagName())) {
                this.dataBindModel.loadFromElement(element);
                continue;
            }
            if (!"SectionCollection".equalsIgnoreCase(element.getTagName())) continue;
            this.sectionCollection.loadFromElement(element);
            for (MetaFCSection section : this.sectionCollection.values()) {
                section.setParent(this);
            }
        }
    }

    @Override
    protected boolean isCollection() {
        return false;
    }

    @Override
    protected boolean saveChild(IContentHandler saveHandler, INode node) {
        this.graphModel.saveTo(saveHandler, node);
        this.dataBindModel.saveTo(saveHandler, node);
        this.sectionCollection.saveTo(saveHandler, node);
        return true;
    }

    @Override
    public void addAttrObserver(Observer observer) {
        super.addAttrObserver(observer);
        this.graphModel.addAttrObserver(observer);
    }

    @Override
    public List<AttributeItem> getPropItems() {
        ArrayList<AttributeItem> items = new ArrayList<AttributeItem>();
        List<AttributeItem> sectionPropItems = super.getPropItems();
        for (AttributeItem attributeItem : sectionPropItems) {
            items.add(attributeItem);
        }
        List<AttributeItem> graphPropItems = this.graphModel.getPropItems();
        for (AttributeItem item : graphPropItems) {
            items.add(item);
        }
        this.dataBindModel.setIsSectionInTable(this.isSectionInTable());
        List<AttributeItem> list = this.dataBindModel.getPropItems();
        for (AttributeItem item : list) {
            items.add(item);
        }
        return items;
    }
}

