/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.bpm.process.transition;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaAssociation;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaDefaultSequenceFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaExceptionFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaSequenceFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaTransition;
import java.util.Iterator;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONObject;

public class MetaTransitionCollection
extends GenericNoKeyCollection<MetaTransition> {
    public static final String TAG_NAME = "TransitionCollection";

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaTransitionCollection();
    }

    private MetaTransition createTransition(String tagName) {
        MetaTransition child = null;
        if (tagName.equalsIgnoreCase("SequenceFlow")) {
            child = new MetaSequenceFlow();
        } else if (tagName.equalsIgnoreCase("ExceptionFlow")) {
            child = new MetaExceptionFlow();
        } else if (tagName.equalsIgnoreCase("Association")) {
            child = new MetaAssociation();
        } else if (tagName.equalsIgnoreCase("DefaultSequenceFlow")) {
            child = new MetaDefaultSequenceFlow();
        }
        return child;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject obj = new JSONObject();
        JSONArray transitionArray = new JSONArray();
        Iterator it = this.elementArray.iterator();
        MetaTransition transition = null;
        while (it.hasNext()) {
            transition = (MetaTransition)it.next();
            transitionArray.put((Object)transition.toJSON());
        }
        obj.put("items", (Object)transitionArray);
        return obj;
    }

    @Override
    public void fromJSON(JSONObject json) {
        if (json.has("items")) {
            JSONArray transitionArray = json.getJSONArray("items");
            int size = transitionArray.length();
            for (int i = 0; i < size; ++i) {
                JSONObject transitionObj = transitionArray.getJSONObject(i);
                String tagName = transitionObj.getString("tag-name");
                MetaTransition transition = this.createTransition(tagName);
                transition.fromJSON(transitionObj);
                this.add(transition);
            }
        }
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        MetaTransition child = null;
        if (tagName.equalsIgnoreCase("SequenceFlow")) {
            child = new MetaSequenceFlow();
        } else if (tagName.equalsIgnoreCase("ExceptionFlow")) {
            child = new MetaExceptionFlow();
        } else if (tagName.equalsIgnoreCase("Association")) {
            child = new MetaAssociation();
        } else if (tagName.equalsIgnoreCase("DefaultSequenceFlow")) {
            child = new MetaDefaultSequenceFlow();
        }
        if (child != null) {
            child.preProcessMetaObject(env, doc, node, flag, runType);
        }
        this.add(child);
        return child;
    }
}

