/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.persist.dom.xml.defaultnode;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.persist.dom.xml.defaultnode.LinkedData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DefaultNode {
    private LinkedData first = null;
    private LinkedData last = null;
    private String primaryKey = null;
    private boolean isSingle = false;
    private String tagName = null;
    protected LinkedHashMap<String, LinkedData> attrs = new LinkedHashMap();

    public DefaultNode(String tagName) {
        this(tagName, false);
    }

    public DefaultNode(String tagName, boolean isSingle) {
        this.tagName = tagName;
        this.isSingle = isSingle;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void addNode(LinkedData node) {
        this.addNode(node, null);
    }

    public void addNode(LinkedData node, LinkedData after) {
        if (this.attrs.size() == 0) {
            this.first = node;
        }
        this.attrs.put(node.getValue(), node);
        if (after != null) {
            LinkedData tmp = after.next;
            after.next = node;
            node.previous = after;
            node.next = tmp;
            if (tmp != null) {
                tmp.previous = node;
            } else {
                this.last = node;
            }
        } else {
            if (this.last != null) {
                this.last.next = node;
                node.previous = this.last;
            }
            this.last = node;
        }
    }

    public LinkedData first() {
        return this.first;
    }

    public LinkedData last() {
        return this.last;
    }

    public LinkedData getNode(String name) {
        return this.attrs.get(name);
    }

    public boolean hasAttribute(String attrName) {
        return this.attrs.containsKey(attrName);
    }

    public boolean hasPrimaryAttribute() {
        return this.primaryKey != null && this.primaryKey.trim().length() > 0;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public Collection<LinkedData> values() {
        return this.attrs.values();
    }

    public void setSingle(boolean b) {
        this.isSingle = b;
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        if ("![CDATA[ ]]>".equals(this.tagName) || "!-- -->".equals(this.tagName)) {
            strBuilder.append("<").append(this.tagName);
        } else {
            strBuilder.append("<").append(this.tagName).append(" ");
            for (Map.Entry<String, LinkedData> entry : this.attrs.entrySet()) {
                if (StringUtil.isEmptyStr((String)entry.getKey())) continue;
                strBuilder.append(entry.getKey()).append("=").append("\"\"").append(" ");
            }
            strBuilder.deleteCharAt(strBuilder.length() - 1);
            if (this.isSingle) {
                strBuilder.append("/>");
            } else {
                strBuilder.append(">\r\n").append("</").append(this.tagName).append(">");
            }
        }
        return strBuilder.toString();
    }

    public List<String> getAttrList() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, LinkedData> entry : this.attrs.entrySet()) {
            list.add(entry.getKey());
        }
        return list;
    }

    public String[] getPopupArray(List<String> filters) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, LinkedData> entry : this.attrs.entrySet()) {
            if (filters != null && filters.contains(entry.getKey())) continue;
            list.add(entry.getKey());
        }
        String[] arr = new String[list.size()];
        list.toArray(arr);
        return arr;
    }
}

