/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.persist.dom.solution;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.datamap.MetaMapLoad;
import com.bokesoft.yes.meta.persist.dom.solution.BaseMetaScanLoad;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.datamap.MetaDataMapList;
import com.bokesoft.yigo.meta.datamap.MetaDataMapProfile;
import com.bokesoft.yigo.meta.datamap.MetaMap;
import com.bokesoft.yigo.meta.solution.MetaProject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;

public class MetaDataMapScanLoad
extends BaseMetaScanLoad {
    private int runType = 1;
    private MetaDataMapList dataMapList;
    private Map<String, MetaDataMapProfile> map = null;

    public MetaDataMapScanLoad(MetaDataMapList dataMapList, IMetaResolver resolver, MetaProject metaProject, Object context, int runType) {
        super(resolver, metaProject, "DataMap", context);
        this.dataMapList = dataMapList;
        this.runType = runType;
        this.map = new ConcurrentHashMap<String, MetaDataMapProfile>();
    }

    protected void doFind(Object parent, String parentPath, String filePath, String fileName, MetaDataMapProfile profile) {
    }

    @Override
    protected void postLoad() throws Throwable {
        super.postLoad();
        this.merge();
    }

    @Override
    public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
        String tagName;
        JSONObject profileInfo = this.resolver.readProfile(filePath, 0);
        if (profileInfo != null && "Map".equals(tagName = profileInfo.optString("TagName"))) {
            MetaMapLoad load = new MetaMapLoad(1);
            load.load(this.resolver, filePath);
            MetaMap dataMap = (MetaMap)load.getRootMetaObject();
            dataMap.setProject(this.metaProject);
            if (dataMap != null) {
                MetaDataMapProfile profile = new MetaDataMapProfile();
                profile.setKey(dataMap.getKey());
                profile.setCaption(dataMap.getCaption());
                profile.setDescription(dataMap.getDescription());
                profile.setSrcDataObjectKey(dataMap.getSrcDataObjectKey());
                profile.setTgtDataObjectKey(dataMap.getTgtDataObjectKey());
                profile.setDataMap(dataMap);
                profile.setProject(this.metaProject);
                profile.setResource(filePath);
                if (this.map.containsKey(profile.getKey())) {
                    throw new MetaException(98, SimpleStringFormat.format((String)StringTable.getString(null, "", "RepeatDataMapDefined"), (Object[])new Object[]{this.metaProject.getKey(), profile.getKey()}));
                }
                this.doFind(parent, parentPath, filePath, fileName, profile);
                this.map.put(profile.getKey(), profile);
            }
        }
    }

    public int getRunType() {
        return this.runType;
    }

    private void merge() {
        if (this.map.isEmpty()) {
            return;
        }
        try {
            this.map.values().forEach(profile -> this.dataMapList.add(profile));
        }
        finally {
            this.map.clear();
        }
    }

    public MetaDataMapList getMetaDataMapList() {
        this.merge();
        return this.dataMapList;
    }
}

