package com.bokesoft.yigo.meta.taskflow.node;

import com.bokesoft.yes.meta.persist.dom.taskflow.NodeType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;

/**
 * 合并节点
 */
public class MetaJoin extends MetaNode {

	public final static String TAG_NAME = "Join";
	
	/** 合并数量 */
	private Integer joinCount = -1;
	
	/**
	 * 获取合并数量
	 * @return 合并数量
	 */
	public Integer getJoinCount() {
		return this.joinCount;
	}
	
	/**
	 * 获取合并数量
	 * @param joinCount 合并数量
	 */
	public void setJoinCount(Integer joinCount) {
		this.joinCount = joinCount;
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getNodeType() {
		return NodeType.JOIN;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaJoin clone = (MetaJoin) super.clone();
		clone.setJoinCount(joinCount);
		return clone;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaJoin();
	}
}