package com.bokesoft.yigo.meta.task.node;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.task.TaskNodeType;

public class MetaTaskJoin extends MetaTaskNode {
	public static final String TAG_NAME = "Join";
	
	private Integer joinCount = -1;
	private MetaBaseScript condition = null;
	
	public Integer getJoinCount() {
		return joinCount;
	}

	public void setJoinCount(Integer joinCount) {
		this.joinCount = joinCount;
	}

	public MetaBaseScript getCondition() {
		return condition;
	}

	public void setCondition(MetaBaseScript condition) {
		this.condition = condition;
	}

	@Override
	public int getNodeType() {
		return TaskNodeType.JOIN;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new  MetaTaskJoin();
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaTaskJoin obj = (MetaTaskJoin) super.clone();
		obj.joinCount = joinCount;
		obj.condition = condition == null ? null : (MetaBaseScript)condition.clone();
		return obj;
	}

}
