package com.bokesoft.yigo.meta.solution;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyPairCompositeCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairCompositeObject;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaProjectFold extends GenericKeyPairCompositeCollection {
	private String key = null;
	private String caption = null;
	
	public MetaProjectFold() {
		super();
	}
	
	public static final String TAG_NAME = "Fold";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getObjectType() {
		return MetaProjectItem.FOLD;
	}

	public void setKey(String key) {
		this.key = key;
	}
	
	@Override
	public String getKey() {
		return key;
	}
	
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	public String getCaption() {
		return caption;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject child = null;
		if ( MetaProjectFold.TAG_NAME.equals(tagName) ) {
			child = new MetaProjectFold();
		} else if ( MetaProjectItem.TAG_NAME.equals(tagName) ) {
			child = new MetaProjectItem();
		}
		if ( child != null ) {
			child.preProcessMetaObject(env, doc, node, flag, runType);
			this.add((KeyPairCompositeObject)child);
		}
		return child;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return null;
	}
}
