package com.bokesoft.yigo.meta.report;

/**
 * 表分页策略
 * @author wangyh
 *
 */
public class ReportTablePageBreakPolicy {
	/** 无分页 */
	public static final int None = 0;
	/** 无分页字符串表示 */
	public static final String STR_None = "None";
	
	/** 根据分组头分页 */
	public static final int GroupHead = 1;
	/** 根据分组头分页字符串表示 */
	public static final String STR_GroupHead = "GroupHead";
	
	/** 强制分页 */
	public static final int ForcedBreak = 2;
	/** 强制分页字符串表示 */
	public static final String STR_ForcedBreak = "ForcedBreak";
	
	/**
	 * 从字符串解析分页类型
	 * @param s 字符串
	 * @return 相应的分页类型
	 */
	public static int parse(String s) {
		int type = None;
		if ( STR_GroupHead.equalsIgnoreCase(s) ) {
			type = GroupHead;
		} else if ( STR_ForcedBreak.equalsIgnoreCase(s) ) {
			type = ForcedBreak;
		}
		return type;
	}
	
	/**
	 * 从分页类型数字表示返回字符串表示
	 * @param type 分页类型
	 * @return 相应的分页类型的字符串表示
	 */
	public static String toString(Integer type) {
		if(type == null)
			return "";
		
		String s = "";
		switch ( type ) {
		case None:
			s = STR_None;
			break;
		case GroupHead:
			s = STR_GroupHead;
			break;
		case ForcedBreak:
			s = STR_ForcedBreak;
			break;
		}
		return s;
	}
}
